/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.List;
import java.util.Locale;
import javax.management.MBeanServer;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.services.path.AbstractPathService;
import org.jboss.as.web.DefaultJspConfig;
import org.jboss.as.web.DefaultStaticResources;
import org.jboss.as.web.SharedTldsMetaDataBuilder;
import org.jboss.as.web.SharedWebMetaDataBuilder;
import org.jboss.as.web.WebServerService;
import org.jboss.as.web.WebSubsystemDescriptions;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.as.web.deployment.EarContextRootProcessor;
import org.jboss.as.web.deployment.JBossWebParsingDeploymentProcessor;
import org.jboss.as.web.deployment.ServletContainerInitializerDeploymentProcessor;
import org.jboss.as.web.deployment.TldParsingDeploymentProcessor;
import org.jboss.as.web.deployment.WarAnnotationDeploymentProcessor;
import org.jboss.as.web.deployment.WarClassloadingDependencyProcessor;
import org.jboss.as.web.deployment.WarDeploymentInitializingProcessor;
import org.jboss.as.web.deployment.WarDeploymentProcessor;
import org.jboss.as.web.deployment.WarMetaDataProcessor;
import org.jboss.as.web.deployment.WarStructureDeploymentProcessor;
import org.jboss.as.web.deployment.WebFragmentParsingDeploymentProcessor;
import org.jboss.as.web.deployment.WebParsingDeploymentProcessor;
import org.jboss.as.web.deployment.component.WebComponentProcessor;
import org.jboss.as.web.deployment.jsf.JsfAnnotationProcessor;
import org.jboss.as.web.deployment.jsf.JsfManagedBeanProcessor;
import org.jboss.as.web.deployment.jsf.JsfVersionProcessor;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

class WebSubsystemAdd
extends AbstractBoottimeAddStepHandler
implements DescriptionProvider {
    static final WebSubsystemAdd INSTANCE = new WebSubsystemAdd();
    private static final String DEFAULT_VIRTUAL_SERVER = "localhost";
    private static final boolean DEFAULT_NATIVE = true;
    private static final String TEMP_DIR = "jboss.server.temp.dir";

    private WebSubsystemAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        ModelNode val;
        ModelNode ourContainerConfig = new ModelNode();
        ModelNode ourStaticResources = DefaultStaticResources.getDefaultStaticResource();
        ourContainerConfig.get("static-resources").set(ourStaticResources);
        ModelNode ourJspConfig = DefaultJspConfig.getDefaultStaticResource();
        ourContainerConfig.get("jsp-configuration").set(ourJspConfig);
        ModelNode opConfig = operation.get("configuration");
        if (opConfig.hasDefined("static-resources")) {
            for (Property prop : opConfig.get("static-resources").asPropertyList()) {
                val = DefaultStaticResources.getDefaultIfUndefined(prop.getName(), prop.getValue());
                ourStaticResources.get(prop.getName()).set(val);
            }
        }
        if (opConfig.hasDefined("jsp-configuration")) {
            for (Property prop : opConfig.get("jsp-configuration").asPropertyList()) {
                val = DefaultStaticResources.getDefaultIfUndefined(prop.getName(), prop.getValue());
                ourStaticResources.get(prop.getName()).set(val);
            }
        }
        if (opConfig.hasDefined("mime-mapping")) {
            ourContainerConfig.get("mime-mapping").set(opConfig.get("mime-mapping"));
        }
        if (opConfig.hasDefined("welcome-file")) {
            ourContainerConfig.get("welcome-file").set(opConfig.get("welcome-file"));
        }
        model.get("configuration").set(ourContainerConfig);
        model.get("connector").setEmptyObject();
        model.get("virtual-server").setEmptyObject();
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        final ModelNode config = operation.get("configuration");
        final String defaultVirtualServer = operation.hasDefined("default-virtual-server") ? operation.get("default-virtual-server").asString() : DEFAULT_VIRTUAL_SERVER;
        boolean useNative = operation.hasDefined("native") ? operation.get("native").asBoolean() : true;
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                SharedWebMetaDataBuilder sharedWebBuilder = new SharedWebMetaDataBuilder(config.clone());
                SharedTldsMetaDataBuilder sharedTldsBuilder = new SharedTldsMetaDataBuilder(config.clone());
                processorTarget.addDeploymentProcessor(Phase.STRUCTURE, 0, (DeploymentUnitProcessor)new WarDeploymentInitializingProcessor());
                processorTarget.addDeploymentProcessor(Phase.STRUCTURE, 1280, (DeploymentUnitProcessor)new WarStructureDeploymentProcessor(sharedWebBuilder.create(), sharedTldsBuilder.create()));
                processorTarget.addDeploymentProcessor(Phase.PARSE, 2816, (DeploymentUnitProcessor)new WebParsingDeploymentProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 3072, (DeploymentUnitProcessor)new WebFragmentParsingDeploymentProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 3584, (DeploymentUnitProcessor)new JBossWebParsingDeploymentProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 3840, (DeploymentUnitProcessor)new TldParsingDeploymentProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 3328, (DeploymentUnitProcessor)new WarAnnotationDeploymentProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 7936, (DeploymentUnitProcessor)new WebComponentProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 4096, (DeploymentUnitProcessor)new EarContextRootProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 8192, (DeploymentUnitProcessor)new WarMetaDataProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 8193, (DeploymentUnitProcessor)new JsfVersionProcessor());
                processorTarget.addDeploymentProcessor(Phase.DEPENDENCIES, 1536, (DeploymentUnitProcessor)new WarClassloadingDependencyProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 768, (DeploymentUnitProcessor)new JsfManagedBeanProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 768, (DeploymentUnitProcessor)new JsfManagedBeanProcessor());
                processorTarget.addDeploymentProcessor(Phase.INSTALL, 4864, (DeploymentUnitProcessor)new ServletContainerInitializerDeploymentProcessor());
                processorTarget.addDeploymentProcessor(Phase.INSTALL, 5632, (DeploymentUnitProcessor)new JsfAnnotationProcessor());
                processorTarget.addDeploymentProcessor(Phase.INSTALL, 7424, (DeploymentUnitProcessor)new WarDeploymentProcessor(defaultVirtualServer));
            }
        }, OperationContext.Stage.RUNTIME);
        WebServerService service = new WebServerService(defaultVirtualServer, useNative);
        newControllers.add(context.getServiceTarget().addService(WebSubsystemServices.JBOSS_WEB, (Service)service).addDependency(AbstractPathService.pathNameOf((String)TEMP_DIR), String.class, service.getPathInjector()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, ServiceName.JBOSS.append(new String[]{"mbean", "server"}), MBeanServer.class, service.getMbeanServer()).setInitialMode(ServiceController.Mode.ON_DEMAND).install());
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }

    public ModelNode getModelDescription(Locale locale) {
        return WebSubsystemDescriptions.getSubsystemAddDescription(locale);
    }
}

