/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.security;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.jboss.as.web.security.SecurityActions;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.SecurityContext;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.callbacks.SecurityContextCallbackHandler;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;

public class JBossWebRealm
extends RealmBase {
    protected AuthenticationManager authenticationManager = null;
    protected AuthorizationManager authorizationManager = null;

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setAuthorizationManager(AuthorizationManager authorizationManager) {
        this.authorizationManager = authorizationManager;
    }

    public Principal authenticate(String username, String credentials) {
        if (username == null && credentials == null) {
            return null;
        }
        if (this.authenticationManager == null) {
            throw new IllegalStateException("Authentication Manager has not been set");
        }
        if (this.authorizationManager == null) {
            throw new IllegalStateException("Authorization Manager has not been set");
        }
        SimplePrincipal userPrincipal = new SimplePrincipal(username);
        Subject subject = new Subject();
        boolean isValid = this.authenticationManager.isValid((Principal)userPrincipal, (Object)credentials, subject);
        if (isValid) {
            SecurityContext sc = SecurityActions.createSecurityContext(this.authenticationManager.getSecurityDomain());
            sc.getUtil().createSubjectInfo((Principal)userPrincipal, (Object)credentials, subject);
            SecurityActions.setSecurityContextOnAssociation(sc);
            SecurityContextCallbackHandler scb = new SecurityContextCallbackHandler(sc);
            RoleGroup roles = this.authorizationManager.getSubjectRoles(subject, (CallbackHandler)scb);
            List rolesAsList = roles.getRoles();
            ArrayList<String> rolesAsStringList = new ArrayList<String>();
            for (Role role : rolesAsList) {
                rolesAsStringList.add(role.getRoleName());
            }
            return new GenericPrincipal((Realm)this, username, credentials, rolesAsStringList);
        }
        return super.authenticate(username, credentials);
    }

    protected String getName() {
        throw new RuntimeException("Handle please");
    }

    protected String getPassword(String username) {
        return null;
    }

    protected Principal getPrincipal(String username) {
        return new SimplePrincipal(username);
    }
}

