/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.threads.Namespace;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.as.threads.ThreadFactoryAdd;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ThreadsSubsystemProviders {
    static final String RESOURCE_NAME = ThreadsSubsystemProviders.class.getPackage().getName() + ".LocalDescriptions";
    static final DescriptionProvider SUBSYSTEM_PROVIDER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = ThreadsSubsystemProviders.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            subsystem.get("description").set(bundle2.getString("threads"));
            subsystem.get("head-comment-allowed").set(true);
            subsystem.get("tail-comment-allowed").set(true);
            subsystem.get("namespace").set(Namespace.THREADS_1_0.getUriString());
            subsystem.get(new String[]{"children", "thread-factory", "description"}).set(bundle2.getString("threadfactories"));
            subsystem.get(new String[]{"children", "thread-factory", "min-occurs"}).set(0);
            subsystem.get(new String[]{"children", "thread-factory", "max-occurs"}).set(Integer.MAX_VALUE);
            subsystem.get(new String[]{"children", "unbounded-queue-thread-pool", "description"}).set(bundle2.getString("threadpool.unbounded"));
            subsystem.get(new String[]{"children", "unbounded-queue-thread-pool", "min-occurs"}).set(0);
            subsystem.get(new String[]{"children", "unbounded-queue-thread-pool", "max-occurs"}).set(Integer.MAX_VALUE);
            subsystem.get(new String[]{"children", "bounded-queue-thread-pool", "description"}).set(bundle2.getString("threadpool.bounded"));
            subsystem.get(new String[]{"children", "bounded-queue-thread-pool", "min-occurs"}).set(0);
            subsystem.get(new String[]{"children", "bounded-queue-thread-pool", "max-occurs"}).set(Integer.MAX_VALUE);
            subsystem.get(new String[]{"children", "queueless-thread-pool", "description"}).set(bundle2.getString("threadpool.queueless"));
            subsystem.get(new String[]{"children", "queueless-thread-pool", "min-occurs"}).set(0);
            subsystem.get(new String[]{"children", "queueless-thread-pool", "max-occurs"}).set(Integer.MAX_VALUE);
            subsystem.get(new String[]{"children", "scheduled-thread-pool", "description"}).set(bundle2.getString("threadpool.scheduled"));
            subsystem.get(new String[]{"children", "scheduled-thread-pool", "min-occurs"}).set(0);
            subsystem.get(new String[]{"children", "scheduled-thread-pool", "max-occurs"}).set(Integer.MAX_VALUE);
            return subsystem;
        }
    };
    static final DescriptionProvider THREAD_FACTORY_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = ThreadsSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle2.getString("threadfactory"));
            node.get("head-comment-allowed").set(true);
            node.get("tail-comment-allowed").set(true);
            for (AttributeDefinition attr : PoolAttributeDefinitions.THREAD_FACTORY_ATTRIBUTES) {
                attr.addResourceAttributeDescription(bundle2, "threadfactory", node);
            }
            return node;
        }
    };
    public static DescriptionProvider BOUNDED_QUEUE_THREAD_POOL_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = ThreadsSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = ThreadsSubsystemProviders.getCommonThreadPool(bundle2, bundle2.getString("threadpool.bounded.description"));
            operation.get(new String[]{"attributes", "blocking", "description"}).set(bundle2.getString("threadpool.bounded.blocking"));
            operation.get(new String[]{"attributes", "blocking", "type"}).set(ModelType.BOOLEAN);
            operation.get(new String[]{"attributes", "blocking", "required"}).set(false);
            operation.get(new String[]{"attributes", "allow-core-timeout", "description"}).set(bundle2.getString("threadpool.bounded.allowcoretimeout"));
            operation.get(new String[]{"attributes", "allow-core-timeout", "type"}).set(ModelType.BOOLEAN);
            operation.get(new String[]{"attributes", "allow-core-timeout", "required"}).set(false);
            operation.get(new String[]{"attributes", "handoff-executor", "description"}).set(bundle2.getString("threadpool.bounded.handoffexecutor"));
            operation.get(new String[]{"attributes", "handoff-executor", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"attributes", "handoff-executor", "required"}).set(false);
            operation.get(new String[]{"attributes", "core-threads", "description"}).set(bundle2.getString("threadpool.bounded.corethreads"));
            operation.get(new String[]{"attributes", "core-threads", "type"}).set(ModelType.OBJECT);
            operation.get(new String[]{"attributes", "core-threads", "required"}).set(false);
            operation.get(new String[]{"attributes", "core-threads", "value-type", "count", "description"}).set(bundle2.getString("threadpool.bounded.corethreads.count"));
            operation.get(new String[]{"attributes", "core-threads", "value-type", "count", "type"}).set(ModelType.INT);
            operation.get(new String[]{"attributes", "core-threads", "value-type", "count", "required"}).set(true);
            operation.get(new String[]{"attributes", "core-threads", "value-type", "per-cpu", "description"}).set(bundle2.getString("threadpool.bounded.corethreads.percpu"));
            operation.get(new String[]{"attributes", "core-threads", "value-type", "per-cpu", "type"}).set(ModelType.INT);
            operation.get(new String[]{"attributes", "core-threads", "value-type", "per-cpu", "required"}).set(true);
            operation.get(new String[]{"attributes", "queue-length", "description"}).set(bundle2.getString("threadpool.bounded.queuelength"));
            operation.get(new String[]{"attributes", "queue-length", "type"}).set(ModelType.OBJECT);
            operation.get(new String[]{"attributes", "queue-length", "required"}).set(true);
            operation.get(new String[]{"attributes", "queue-length", "value-type", "count", "description"}).set(bundle2.getString("threadpool.bounded.queuelength.count"));
            operation.get(new String[]{"attributes", "queue-length", "value-type", "count", "type"}).set(ModelType.INT);
            operation.get(new String[]{"attributes", "queue-length", "value-type", "count", "required"}).set(true);
            operation.get(new String[]{"attributes", "queue-length", "value-type", "per-cpu", "description"}).set(bundle2.getString("threadpool.bounded.queuelength.percpu"));
            operation.get(new String[]{"attributes", "queue-length", "value-type", "per-cpu", "type"}).set(ModelType.INT);
            operation.get(new String[]{"attributes", "queue-length", "value-type", "per-cpu", "required"}).set(true);
            return operation;
        }
    };
    static final DescriptionProvider UNBOUNDED_QUEUE_THREAD_POOL_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = ThreadsSubsystemProviders.getResourceBundle(locale);
            return ThreadsSubsystemProviders.getCommonThreadPool(bundle2, bundle2.getString("threadpool.unbounded.description"));
        }
    };
    static final DescriptionProvider QUEUELESS_THREAD_POOL_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = ThreadsSubsystemProviders.getResourceBundle(locale);
            ModelNode node = ThreadsSubsystemProviders.getCommonThreadPool(bundle2, bundle2.getString("threadpool.queueless.description"));
            node.get(new String[]{"attributes", "blocking", "description"}).set(bundle2.getString("threadpool.queueless.blocking"));
            node.get(new String[]{"attributes", "blocking", "type"}).set(ModelType.BOOLEAN);
            node.get(new String[]{"attributes", "blocking", "required"}).set(true);
            node.get(new String[]{"attributes", "handoff-executor", "description"}).set(bundle2.getString("threadpool.queueless.handoffexecutor"));
            node.get(new String[]{"attributes", "handoff-executor", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "handoff-executor", "required"}).set(true);
            return node;
        }
    };
    static final DescriptionProvider SCHEDULED_THREAD_POOL_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = ThreadsSubsystemProviders.getResourceBundle(locale);
            return ThreadsSubsystemProviders.getCommonThreadPool(bundle2, bundle2.getString("threadpool.scheduled.description"));
        }
    };
    static final DescriptionProvider SUBSYSTEM_ADD_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = ThreadsSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle2.getString("threads.add"));
            operation.get("request-properties").setEmptyObject();
            operation.get("reply-properties").setEmptyObject();
            return operation;
        }
    };
    static DescriptionProvider ADD_THREAD_FACTORY_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = ThreadsSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle2.getString("threadfactory.add"));
            for (AttributeDefinition attr : ThreadFactoryAdd.ATTRIBUTES) {
                attr.addOperationParameterDescription(bundle2, "threadfactory", operation);
            }
            operation.get("reply-properties").setEmptyObject();
            return operation;
        }
    };
    static DescriptionProvider REMOVE_THREAD_FACTORY_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = ThreadsSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("remove");
            operation.get("description").set(bundle2.getString("threadfactory.remove"));
            operation.get(new String[]{"request-properties", "name", "description"}).set(bundle2.getString("threadfactory.remove"));
            operation.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "name", "required"}).set(true);
            operation.get("reply-properties").setEmptyObject();
            return operation;
        }
    };
    static DescriptionProvider ADD_BOUNDED_QUEUE_THREAD_POOL_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = ThreadsSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = ThreadsSubsystemProviders.getCommonAddThreadPool(bundle2, "add", bundle2.getString("threadpool.bounded.add"));
            operation.get(new String[]{"request-properties", "blocking", "description"}).set(bundle2.getString("threadpool.bounded.blocking"));
            operation.get(new String[]{"request-properties", "blocking", "type"}).set(ModelType.BOOLEAN);
            operation.get(new String[]{"request-properties", "blocking", "required"}).set(false);
            operation.get(new String[]{"request-properties", "allow-core-timeout", "description"}).set(bundle2.getString("threadpool.bounded.allowcoretimeout"));
            operation.get(new String[]{"request-properties", "allow-core-timeout", "type"}).set(ModelType.BOOLEAN);
            operation.get(new String[]{"request-properties", "allow-core-timeout", "required"}).set(false);
            operation.get(new String[]{"request-properties", "handoff-executor", "description"}).set(bundle2.getString("threadpool.bounded.handoffexecutor"));
            operation.get(new String[]{"request-properties", "handoff-executor", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "handoff-executor", "required"}).set(false);
            operation.get(new String[]{"request-properties", "core-threads", "description"}).set(bundle2.getString("threadpool.bounded.corethreads"));
            operation.get(new String[]{"request-properties", "core-threads", "type"}).set(ModelType.OBJECT);
            operation.get(new String[]{"request-properties", "core-threads", "required"}).set(false);
            operation.get(new String[]{"request-properties", "core-threads", "value-type", "count", "description"}).set(bundle2.getString("threadpool.bounded.corethreads.count"));
            operation.get(new String[]{"request-properties", "core-threads", "value-type", "count", "type"}).set(ModelType.INT);
            operation.get(new String[]{"request-properties", "core-threads", "value-type", "count", "required"}).set(true);
            operation.get(new String[]{"request-properties", "core-threads", "value-type", "per-cpu", "description"}).set(bundle2.getString("threadpool.bounded.corethreads.percpu"));
            operation.get(new String[]{"request-properties", "core-threads", "value-type", "per-cpu", "type"}).set(ModelType.INT);
            operation.get(new String[]{"request-properties", "core-threads", "value-type", "per-cpu", "required"}).set(true);
            operation.get(new String[]{"request-properties", "queue-length", "description"}).set(bundle2.getString("threadpool.bounded.queuelength"));
            operation.get(new String[]{"request-properties", "queue-length", "type"}).set(ModelType.OBJECT);
            operation.get(new String[]{"request-properties", "queue-length", "required"}).set(true);
            operation.get(new String[]{"request-properties", "queue-length", "value-type", "count", "description"}).set(bundle2.getString("threadpool.bounded.queuelength.count"));
            operation.get(new String[]{"request-properties", "queue-length", "value-type", "count", "type"}).set(ModelType.INT);
            operation.get(new String[]{"request-properties", "queue-length", "value-type", "count", "required"}).set(true);
            operation.get(new String[]{"request-properties", "queue-length", "value-type", "per-cpu", "description"}).set(bundle2.getString("threadpool.bounded.queuelength.percpu"));
            operation.get(new String[]{"request-properties", "queue-length", "value-type", "per-cpu", "type"}).set(ModelType.INT);
            operation.get(new String[]{"request-properties", "queue-length", "value-type", "per-cpu", "required"}).set(true);
            return operation;
        }
    };
    static DescriptionProvider ADD_QUEUELESS_THREAD_POOL_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = ThreadsSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = ThreadsSubsystemProviders.getCommonAddThreadPool(bundle2, "add", bundle2.getString("threadpool.queueless.add"));
            operation.get(new String[]{"request-properties", "blocking", "description"}).set(bundle2.getString("threadpool.queueless.blocking"));
            operation.get(new String[]{"request-properties", "blocking", "type"}).set(ModelType.BOOLEAN);
            operation.get(new String[]{"request-properties", "blocking", "required"}).set(true);
            operation.get(new String[]{"request-properties", "handoff-executor", "description"}).set(bundle2.getString("threadpool.queueless.handoffexecutor"));
            operation.get(new String[]{"request-properties", "handoff-executor", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "handoff-executor", "required"}).set(true);
            return operation;
        }
    };
    static DescriptionProvider ADD_UNBOUNDED_QUEUE_THREAD_POOL_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = ThreadsSubsystemProviders.getResourceBundle(locale);
            return ThreadsSubsystemProviders.getCommonAddThreadPool(bundle2, "add", bundle2.getString("threadpool.unbounded.add"));
        }
    };
    static DescriptionProvider ADD_SCHEDULED_THREAD_POOL_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = ThreadsSubsystemProviders.getResourceBundle(locale);
            return ThreadsSubsystemProviders.getCommonAddThreadPool(bundle2, "add", bundle2.getString("threadpool.scheduled.add"));
        }
    };
    static DescriptionProvider REMOVE_BOUNDED_QUEUE_THREAD_POOL_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = ThreadsSubsystemProviders.getResourceBundle(locale);
            return ThreadsSubsystemProviders.getCommonRemoveThreadPool(bundle2, "remove", bundle2.getString("threadpool.bounded.remove"));
        }
    };
    static DescriptionProvider REMOVE_QUEUELESS_THREAD_POOL_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = ThreadsSubsystemProviders.getResourceBundle(locale);
            return ThreadsSubsystemProviders.getCommonRemoveThreadPool(bundle2, "remove", bundle2.getString("threadpool.queueless.remove"));
        }
    };
    static DescriptionProvider REMOVE_UNBOUNDED_QUEUE_THREAD_POOL_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = ThreadsSubsystemProviders.getResourceBundle(locale);
            return ThreadsSubsystemProviders.getCommonRemoveThreadPool(bundle2, "remove", bundle2.getString("threadpool.unbounded.remove"));
        }
    };
    static DescriptionProvider REMOVE_SCHEDULED_THREAD_POOL_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = ThreadsSubsystemProviders.getResourceBundle(locale);
            return ThreadsSubsystemProviders.getCommonRemoveThreadPool(bundle2, "remove", bundle2.getString("threadpool.scheduled.remove"));
        }
    };

    private static ModelNode getCommonThreadPool(ResourceBundle bundle2, String description) {
        ModelNode node = new ModelNode();
        node.get("description").set(description);
        node.get("head-comment-allowed").set(true);
        node.get("tail-comment-allowed").set(true);
        node.get(new String[]{"attributes", "name", "description"}).set(bundle2.getString("threadpool.common.name"));
        node.get(new String[]{"attributes", "name", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "name", "required"}).set(true);
        node.get(new String[]{"attributes", "thread-factory", "description"}).set(bundle2.getString("threadpool.common.threadfactory"));
        node.get(new String[]{"attributes", "thread-factory", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "thread-factory", "required"}).set(false);
        node.get(new String[]{"attributes", "properties", "description"}).set(bundle2.getString("threadpool.common.properties"));
        node.get(new String[]{"attributes", "properties", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"attributes", "properties", "value-type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "properties", "required"}).set(false);
        node.get(new String[]{"attributes", "max-threads", "description"}).set(bundle2.getString("threadpool.common.maxthreads"));
        node.get(new String[]{"attributes", "max-threads", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"attributes", "max-threads", "required"}).set(true);
        node.get(new String[]{"attributes", "max-threads", "value-type", "count", "description"}).set(bundle2.getString("threadpool.common.maxthreads.count"));
        node.get(new String[]{"attributes", "max-threads", "value-type", "count", "type"}).set(ModelType.INT);
        node.get(new String[]{"attributes", "max-threads", "value-type", "count", "required"}).set(true);
        node.get(new String[]{"attributes", "max-threads", "value-type", "per-cpu", "description"}).set(bundle2.getString("threadpool.common.maxthreads.percpu"));
        node.get(new String[]{"attributes", "max-threads", "value-type", "per-cpu", "type"}).set(ModelType.INT);
        node.get(new String[]{"attributes", "max-threads", "value-type", "per-cpu", "required"}).set(true);
        node.get(new String[]{"attributes", "keepalive-time", "description"}).set(bundle2.getString("threadpool.common.keepalive"));
        node.get(new String[]{"attributes", "keepalive-time", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"attributes", "keepalive-time", "required"}).set(false);
        node.get(new String[]{"attributes", "keepalive-time", "value-type", "time", "description"}).set(bundle2.getString("threadpool.common.keepalive.time"));
        node.get(new String[]{"attributes", "keepalive-time", "value-type", "time", "type"}).set(ModelType.LONG);
        node.get(new String[]{"attributes", "keepalive-time", "value-type", "time", "required"}).set(true);
        node.get(new String[]{"attributes", "keepalive-time", "value-type", "unit", "description"}).set(bundle2.getString("threadpool.common.keepalive.unit"));
        node.get(new String[]{"attributes", "keepalive-time", "value-type", "unit", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "keepalive-time", "value-type", "unit", "required"}).set(true);
        return node;
    }

    static ModelNode getCommonAddThreadPool(ResourceBundle bundle2, String operationName, String description) {
        ModelNode operation = new ModelNode();
        operation.get("operation-name").set(operationName);
        operation.get("description").set(description);
        operation.get(new String[]{"request-properties", "name", "description"}).set(bundle2.getString("threadpool.common.name"));
        operation.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
        operation.get(new String[]{"request-properties", "name", "required"}).set(false);
        operation.get(new String[]{"request-properties", "thread-factory", "description"}).set(bundle2.getString("threadpool.common.threadfactory"));
        operation.get(new String[]{"request-properties", "thread-factory", "type"}).set(ModelType.STRING);
        operation.get(new String[]{"request-properties", "thread-factory", "required"}).set(false);
        operation.get(new String[]{"request-properties", "properties", "description"}).set(bundle2.getString("threadpool.common.properties"));
        operation.get(new String[]{"request-properties", "properties", "type"}).set(ModelType.OBJECT);
        operation.get(new String[]{"request-properties", "properties", "value-type"}).set(ModelType.STRING);
        operation.get(new String[]{"request-properties", "properties", "required"}).set(false);
        operation.get(new String[]{"request-properties", "max-threads", "description"}).set(bundle2.getString("threadpool.common.maxthreads"));
        operation.get(new String[]{"request-properties", "max-threads", "type"}).set(ModelType.OBJECT);
        operation.get(new String[]{"request-properties", "max-threads", "required"}).set(true);
        operation.get(new String[]{"request-properties", "max-threads", "value-type", "count", "description"}).set(bundle2.getString("threadpool.common.maxthreads.count"));
        operation.get(new String[]{"request-properties", "max-threads", "value-type", "count", "type"}).set(ModelType.INT);
        operation.get(new String[]{"request-properties", "max-threads", "value-type", "count", "required"}).set(true);
        operation.get(new String[]{"request-properties", "max-threads", "value-type", "per-cpu", "description"}).set(bundle2.getString("threadpool.common.maxthreads.percpu"));
        operation.get(new String[]{"request-properties", "max-threads", "value-type", "per-cpu", "type"}).set(ModelType.INT);
        operation.get(new String[]{"request-properties", "max-threads", "value-type", "per-cpu", "required"}).set(true);
        operation.get(new String[]{"request-properties", "keepalive-time", "description"}).set(bundle2.getString("threadpool.common.keepalive"));
        operation.get(new String[]{"request-properties", "keepalive-time", "type"}).set(ModelType.OBJECT);
        operation.get(new String[]{"request-properties", "keepalive-time", "required"}).set(false);
        operation.get(new String[]{"request-properties", "keepalive-time", "value-type", "time", "description"}).set(bundle2.getString("threadpool.common.keepalive.time"));
        operation.get(new String[]{"request-properties", "keepalive-time", "value-type", "time", "type"}).set(ModelType.LONG);
        operation.get(new String[]{"request-properties", "keepalive-time", "value-type", "time", "required"}).set(true);
        operation.get(new String[]{"request-properties", "keepalive-time", "value-type", "unit", "description"}).set(bundle2.getString("threadpool.common.keepalive.unit"));
        operation.get(new String[]{"request-properties", "keepalive-time", "value-type", "unit", "type"}).set(ModelType.STRING);
        operation.get(new String[]{"request-properties", "keepalive-time", "value-type", "unit", "required"}).set(true);
        operation.get("reply-properties").setEmptyObject();
        return operation;
    }

    private static ModelNode getCommonRemoveThreadPool(ResourceBundle bundle2, String operationName, String description) {
        ModelNode operation = new ModelNode();
        operation.get("operation-name").set(operationName);
        operation.get("description").set(description);
        operation.get("reply-properties").setEmptyObject();
        return operation;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }

    public static ModelNode addThreadsDescriptionsToNode(Locale locale, ModelNode node) {
        ResourceBundle bundle2 = ThreadsSubsystemProviders.getResourceBundle(locale);
        node.get(new String[]{"children", "thread-factory", "description"}).set(bundle2.getString("threadfactories"));
        node.get(new String[]{"children", "thread-factory", "required"}).set(false);
        node.get(new String[]{"children", "unbounded-queue-thread-pool", "description"}).set(bundle2.getString("threadpool.unbounded"));
        node.get(new String[]{"children", "unbounded-queue-thread-pool", "required"}).set(false);
        node.get(new String[]{"children", "bounded-queue-thread-pool", "description"}).set(bundle2.getString("threadpool.bounded"));
        node.get(new String[]{"children", "bounded-queue-thread-pool", "required"}).set(false);
        node.get(new String[]{"children", "queueless-thread-pool", "description"}).set(bundle2.getString("threadpool.queueless"));
        node.get(new String[]{"children", "queueless-thread-pool", "required"}).set(false);
        node.get(new String[]{"children", "scheduled-thread-pool", "description"}).set(bundle2.getString("threadpool.scheduled"));
        node.get(new String[]{"children", "scheduled-thread-pool", "required"}).set(false);
        return node;
    }
}

