/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.threads.ThreadFactoryService;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public final class ThreadFactoryPriorityUpdate
implements OperationStepHandler {
    private static final long serialVersionUID = 4253625376544201028L;
    public static final ThreadFactoryPriorityUpdate INSTANCE = new ThreadFactoryPriorityUpdate();
    private final ParametersValidator validator = new ParametersValidator();

    private ThreadFactoryPriorityUpdate() {
        this.validator.registerValidator("value", (ParameterValidator)new IntRangeValidator(1, 10, true, true));
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Integer newPriority;
        ModelNode newValue;
        this.validator.validate(operation);
        final String name = Util.getNameFromAddress((ModelNode)operation.require("address"));
        ModelNode model = context.readModelForUpdate(PathAddress.EMPTY_ADDRESS);
        if (!model.isDefined()) {
            throw new OperationFailedException(this.notConfigured(name));
        }
        ModelNode oldValue = model.get("priority");
        if (operation.hasDefined("value")) {
            newValue = operation.get("value");
            newPriority = newValue.resolve().asInt();
        } else {
            newValue = new ModelNode();
            newPriority = null;
        }
        model.get("priority").set(newValue);
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceController service = context.getServiceRegistry(false).getService(ThreadsServices.threadFactoryName(name));
                    if (service == null) {
                        throw new OperationFailedException(ThreadFactoryPriorityUpdate.this.notConfigured(name));
                    }
                    ThreadFactoryService threadFactoryService = (ThreadFactoryService)service.getValue();
                    threadFactoryService.setPriority(newPriority);
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    private ModelNode notConfigured(String name) {
        return new ModelNode().set(String.format("No thread factory named %s is configured", name));
    }
}

