/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.threads.Attribute;
import org.jboss.as.threads.Element;
import org.jboss.as.threads.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public final class ThreadsParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    static final ThreadsParser INSTANCE = new ThreadsParser();
    private static String SUBSYSTEM_NAME = "threads";

    public static ThreadsParser getInstance() {
        return INSTANCE;
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode address = new ModelNode();
        address.add("subsystem", SUBSYSTEM_NAME);
        address.protect();
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(address);
        list.add(subsystem);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case THREADS_1_0: {
                    this.readSingleElement(reader, list, address);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private String readSingleElement(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode address) throws XMLStreamException {
        String name = null;
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case BOUNDED_QUEUE_THREAD_POOL: {
                name = this.parseBoundedQueueThreadPool(reader, address, list);
                break;
            }
            case THREAD_FACTORY: {
                name = this.parseThreadFactory(reader, address, list);
                break;
            }
            case QUEUELESS_THREAD_POOL: {
                name = this.parseQueuelessThreadPool(reader, address, list);
                break;
            }
            case SCHEDULED_THREAD_POOL: {
                name = this.parseScheduledThreadPool(reader, address, list);
                break;
            }
            case UNBOUNDED_QUEUE_THREAD_POOL: {
                name = this.parseUnboundedQueueThreadPool(reader, address, list);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
        return name;
    }

    public String parseThreadFactory(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        return this.parseThreadFactory(reader, parentAddress, list, "thread-factory", null);
    }

    public String parseThreadFactory(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list, String childAddress, String providedName) throws XMLStreamException {
        ModelNode op = new ModelNode();
        list.add(op);
        op.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block11;
                }
                case GROUP_NAME: {
                    op.get("group-name").set(value);
                    continue block11;
                }
                case THREAD_NAME_PATTERN: {
                    op.get("thread-name-pattern").set(value);
                    continue block11;
                }
                case PRIORITY: {
                    try {
                        int priority = Integer.valueOf(value);
                        op.get("priority").set(priority);
                    }
                    catch (NumberFormatException e) {
                        ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (providedName != null) {
            name = providedName;
        } else if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ModelNode address = parentAddress.clone();
        address.add(childAddress, name);
        address.protect();
        op.get("address").set(address);
        if (reader.hasNext() && reader.nextTag() != 2) {
            switch (Element.forName(reader.getLocalName())) {
                case PROPERTIES: {
                    ModelNode props = this.parseProperties(reader);
                    if (!props.isDefined()) break;
                    op.get("properties").set(props);
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        return name;
    }

    public String parseBoundedQueueThreadPool(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        return this.parseBoundedQueueThreadPool(reader, parentAddress, list, "bounded-queue-thread-pool", null);
    }

    public String parseBoundedQueueThreadPool(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list, String childAddress, String providedName) throws XMLStreamException {
        ModelNode op = new ModelNode();
        list.add(op);
        op.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block14;
                }
                case BLOCKING: {
                    op.get("blocking").set(Boolean.valueOf(value).booleanValue());
                    continue block14;
                }
                case ALLOW_CORE_TIMEOUT: {
                    op.get("allow-core-timeout").set(Boolean.valueOf(value).booleanValue());
                    continue block14;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (providedName != null) {
            name = providedName;
        } else if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ModelNode address = parentAddress.clone();
        address.add(childAddress, name);
        address.protect();
        op.get("address").set(address);
        boolean foundQueueLength = false;
        boolean foundMaxThreads = false;
        block15: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Element.forName(reader.getLocalName())) {
                case CORE_THREADS: {
                    op.get("core-threads").set(this.parseScaledCount(reader));
                    continue block15;
                }
                case HANDOFF_EXECUTOR: {
                    op.get("handoff-executor").set(this.parseRef(reader));
                    continue block15;
                }
                case MAX_THREADS: {
                    op.get("max-threads").set(this.parseScaledCount(reader));
                    foundMaxThreads = true;
                    continue block15;
                }
                case KEEPALIVE_TIME: {
                    op.get("keepalive-time").set(this.parseTimeSpec(reader));
                    continue block15;
                }
                case THREAD_FACTORY: {
                    op.get("thread-factory").set(this.parseRef(reader));
                    continue block15;
                }
                case PROPERTIES: {
                    ModelNode props = this.parseProperties(reader);
                    if (!props.isDefined()) continue block15;
                    op.get("properties").set(props);
                    continue block15;
                }
                case QUEUE_LENGTH: {
                    op.get("queue-length").set(this.parseScaledCount(reader));
                    foundQueueLength = true;
                    continue block15;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!foundMaxThreads || !foundQueueLength) {
            HashSet<Element> missing = new HashSet<Element>();
            if (!foundMaxThreads) {
                missing.add(Element.MAX_THREADS);
            }
            if (!foundQueueLength) {
                missing.add(Element.QUEUE_LENGTH);
            }
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, missing);
        }
        return name;
    }

    public String parseUnboundedQueueThreadPool(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        return this.parseUnboundedQueueThreadPool(reader, parentAddress, list, "unbounded-queue-thread-pool", null);
    }

    public String parseUnboundedQueueThreadPool(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list, String childAddress, String providedName) throws XMLStreamException {
        ModelNode op = new ModelNode();
        list.add(op);
        op.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (providedName != null) {
            name = providedName;
        } else if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ModelNode address = parentAddress.clone();
        address.add(childAddress, name);
        address.protect();
        op.get("address").set(address);
        boolean foundMaxThreads = false;
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Element.forName(reader.getLocalName())) {
                case MAX_THREADS: {
                    op.get("max-threads").set(this.parseScaledCount(reader));
                    foundMaxThreads = true;
                    continue block10;
                }
                case KEEPALIVE_TIME: {
                    op.get("keepalive-time").set(this.parseTimeSpec(reader));
                    continue block10;
                }
                case THREAD_FACTORY: {
                    op.get("thread-factory").set(this.parseRef(reader));
                    continue block10;
                }
                case PROPERTIES: {
                    ModelNode props = this.parseProperties(reader);
                    if (!props.isDefined()) continue block10;
                    op.get("properties").set(props);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!foundMaxThreads) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton(Element.MAX_THREADS));
        }
        return name;
    }

    public String parseScheduledThreadPool(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        return this.parseScheduledThreadPool(reader, parentAddress, list, "scheduled-thread-pool", null);
    }

    public String parseScheduledThreadPool(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list, String childAddress, String providedName) throws XMLStreamException {
        ModelNode op = new ModelNode();
        list.add(op);
        op.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (providedName != null) {
            name = providedName;
        } else if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ModelNode address = parentAddress.clone();
        address.add(childAddress, name);
        address.protect();
        op.get("address").set(address);
        boolean foundMaxThreads = false;
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Element.forName(reader.getLocalName())) {
                case MAX_THREADS: {
                    op.get("max-threads").set(this.parseScaledCount(reader));
                    foundMaxThreads = true;
                    continue block10;
                }
                case KEEPALIVE_TIME: {
                    op.get("keepalive-time").set(this.parseTimeSpec(reader));
                    continue block10;
                }
                case THREAD_FACTORY: {
                    op.get("thread-factory").set(this.parseRef(reader));
                    continue block10;
                }
                case PROPERTIES: {
                    ModelNode props = this.parseProperties(reader);
                    if (!props.isDefined()) continue block10;
                    op.get("properties").set(props);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!foundMaxThreads) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton(Element.MAX_THREADS));
        }
        return name;
    }

    public String parseQueuelessThreadPool(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        return this.parseQueuelessThreadPool(reader, parentAddress, list, "queueless-thread-pool", null);
    }

    public String parseQueuelessThreadPool(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list, String childAddress, String providedName) throws XMLStreamException {
        ModelNode op = new ModelNode();
        list.add(op);
        op.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block11;
                }
                case BLOCKING: {
                    op.get("blocking").set(Boolean.valueOf(value).booleanValue());
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (providedName != null) {
            name = providedName;
        } else if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ModelNode address = parentAddress.clone();
        address.add(childAddress, name);
        address.protect();
        op.get("address").set(address);
        boolean foundMaxThreads = false;
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Element.forName(reader.getLocalName())) {
                case HANDOFF_EXECUTOR: {
                    op.get("handoff-executor").set(this.parseRef(reader));
                    continue block12;
                }
                case MAX_THREADS: {
                    op.get("max-threads").set(this.parseScaledCount(reader));
                    foundMaxThreads = true;
                    continue block12;
                }
                case KEEPALIVE_TIME: {
                    op.get("keepalive-time").set(this.parseTimeSpec(reader));
                    continue block12;
                }
                case THREAD_FACTORY: {
                    op.get("thread-factory").set(this.parseRef(reader));
                    continue block12;
                }
                case PROPERTIES: {
                    ModelNode props = this.parseProperties(reader);
                    if (!props.isDefined()) continue block12;
                    op.get("properties").set(props);
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!foundMaxThreads) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton(Element.MAX_THREADS));
        }
        return name;
    }

    private ModelNode parseScaledCount(XMLExtendedStreamReader reader) throws XMLStreamException {
        int attrCount = reader.getAttributeCount();
        BigDecimal count = null;
        BigDecimal perCpu = null;
        block8: for (int i = 0; i < attrCount; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case COUNT: {
                    try {
                        count = new BigDecimal(value);
                        continue block8;
                    }
                    catch (NumberFormatException e) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
                case PER_CPU: {
                    try {
                        perCpu = new BigDecimal(value);
                        continue block8;
                    }
                    catch (NumberFormatException e) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (count == null || perCpu == null) {
            HashSet<Attribute> missing = new HashSet<Attribute>();
            if (count == null) {
                missing.add(Attribute.COUNT);
            }
            if (perCpu == null) {
                missing.add(Attribute.PER_CPU);
            }
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, missing);
        }
        if (reader.hasNext() && reader.nextTag() != 2) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode node = new ModelNode();
        node.get("count").set(count);
        node.get("per-cpu").set(perCpu);
        return node;
    }

    private ModelNode parseTimeSpec(XMLExtendedStreamReader reader) throws XMLStreamException {
        int attrCount = reader.getAttributeCount();
        TimeUnit unit = null;
        Long duration = null;
        block4: for (int i = 0; i < attrCount; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TIME: {
                    duration = reader.getLongAttributeValue(i);
                    continue block4;
                }
                case UNIT: {
                    unit = Enum.valueOf(TimeUnit.class, value.toUpperCase());
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (duration == null || unit == null) {
            HashSet<Attribute> missing = new HashSet<Attribute>();
            if (duration == null) {
                missing.add(Attribute.TIME);
            }
            if (unit == null) {
                missing.add(Attribute.UNIT);
            }
        }
        if (reader.hasNext() && reader.nextTag() != 2) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode node = new ModelNode();
        node.get("time").set(duration.longValue());
        node.get("unit").set(unit.toString());
        return node;
    }

    private String parseRef(XMLExtendedStreamReader reader) throws XMLStreamException {
        int attrCount = reader.getAttributeCount();
        String refName = null;
        block3: for (int i = 0; i < attrCount; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    refName = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (refName == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
        }
        if (reader.hasNext() && reader.nextTag() != 2) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return refName;
    }

    private ModelNode parseProperties(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode node = new ModelNode();
        while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Element.forName(reader.getLocalName())) {
                case PROPERTY: {
                    int attrCount = reader.getAttributeCount();
                    String propName = null;
                    String propValue = null;
                    block8: for (int i = 0; i < attrCount; ++i) {
                        ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                        String value = reader.getAttributeValue(i);
                        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case NAME: {
                                propName = value;
                                continue block8;
                            }
                            case VALUE: {
                                propValue = value;
                                continue block8;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    if (propName == null || propValue == null) {
                        HashSet<Attribute> missing = new HashSet<Attribute>();
                        if (propName == null) {
                            missing.add(Attribute.NAME);
                        }
                        if (propValue == null) {
                            missing.add(Attribute.VALUE);
                        }
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, missing);
                    }
                    node.add(propName, propValue);
                    if (!reader.hasNext() || reader.nextTag() == 2) break;
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        return node;
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        this.writeThreadsElement(writer, node);
        writer.writeEndElement();
    }

    public void writeThreadsElement(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        ModelNode child;
        if (node.hasDefined("thread-factory")) {
            for (String name : node.get("thread-factory").keys()) {
                child = node.get(new String[]{"thread-factory", name});
                if (!child.isDefined()) continue;
                this.writeThreadFactory(writer, child);
            }
        }
        if (node.hasDefined("bounded-queue-thread-pool")) {
            for (String name : node.get("bounded-queue-thread-pool").keys()) {
                child = node.get(new String[]{"bounded-queue-thread-pool", name});
                if (!child.isDefined()) continue;
                this.writeBoundedQueueThreadPool(writer, child);
            }
        }
        if (node.hasDefined("queueless-thread-pool")) {
            for (String name : node.get("queueless-thread-pool").keys()) {
                child = node.get(new String[]{"queueless-thread-pool", name});
                if (!child.isDefined()) continue;
                this.writeQueuelessThreadPool(writer, child);
            }
        }
        if (node.hasDefined("scheduled-thread-pool")) {
            for (String name : node.get("scheduled-thread-pool").keys()) {
                child = node.get(new String[]{"scheduled-thread-pool", name});
                if (!child.isDefined()) continue;
                this.writeScheduledQueueThreadPool(writer, child);
            }
        }
        if (node.hasDefined("unbounded-queue-thread-pool")) {
            for (String name : node.get("unbounded-queue-thread-pool").keys()) {
                child = node.get(new String[]{"unbounded-queue-thread-pool", name});
                if (!child.isDefined()) continue;
                this.writeUnboundedQueueThreadPool(writer, child);
            }
        }
    }

    public void writeThreadFactory(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        this.writeThreadFactory(writer, node, Element.THREAD_FACTORY.getLocalName(), true);
    }

    public void writeThreadFactory(XMLExtendedStreamWriter writer, ModelNode node, String elementName, boolean includeName) throws XMLStreamException {
        writer.writeStartElement(elementName);
        if (includeName && node.hasDefined("name")) {
            this.writeAttribute(writer, Attribute.NAME, node.get("name"));
        }
        if (node.hasDefined("group-name")) {
            this.writeAttribute(writer, Attribute.GROUP_NAME, node.get("group-name"));
        }
        if (node.hasDefined("thread-name-pattern")) {
            this.writeAttribute(writer, Attribute.THREAD_NAME_PATTERN, node.get("thread-name-pattern"));
        }
        if (node.hasDefined("priority")) {
            this.writeAttribute(writer, Attribute.PRIORITY, node.get("priority"));
        }
        if (node.hasDefined("properties")) {
            this.writeProperties(writer, node.get("properties"));
        }
        writer.writeEndElement();
    }

    public void writeBoundedQueueThreadPool(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        this.writeBoundedQueueThreadPool(writer, node, Element.BOUNDED_QUEUE_THREAD_POOL.getLocalName(), true);
    }

    public void writeBoundedQueueThreadPool(XMLExtendedStreamWriter writer, ModelNode node, String elementName, boolean includeName) throws XMLStreamException {
        writer.writeStartElement(elementName);
        if (includeName && node.hasDefined("name")) {
            this.writeAttribute(writer, Attribute.NAME, node.get("name"));
        }
        if (node.hasDefined("blocking")) {
            this.writeAttribute(writer, Attribute.BLOCKING, node.get("blocking"));
        }
        if (node.hasDefined("allow-core-timeout")) {
            this.writeAttribute(writer, Attribute.ALLOW_CORE_TIMEOUT, node.get("allow-core-timeout"));
        }
        this.writeRef(writer, node, Element.HANDOFF_EXECUTOR, "handoff-executor");
        this.writeRef(writer, node, Element.THREAD_FACTORY, "thread-factory");
        this.writeThreads(writer, node, Element.CORE_THREADS);
        this.writeThreads(writer, node, Element.QUEUE_LENGTH);
        this.writeThreads(writer, node, Element.MAX_THREADS);
        this.writeTime(writer, node, Element.KEEPALIVE_TIME);
        if (node.hasDefined("properties")) {
            this.writeProperties(writer, node.get("properties"));
        }
        writer.writeEndElement();
    }

    public void writeQueuelessThreadPool(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        this.writeQueuelessThreadPool(writer, node, Element.QUEUELESS_THREAD_POOL.getLocalName(), true);
    }

    public void writeQueuelessThreadPool(XMLExtendedStreamWriter writer, ModelNode node, String elementName, boolean includeName) throws XMLStreamException {
        writer.writeStartElement(elementName);
        if (includeName && node.hasDefined("name")) {
            this.writeAttribute(writer, Attribute.NAME, node.get("name"));
        }
        if (node.hasDefined("blocking")) {
            this.writeAttribute(writer, Attribute.BLOCKING, node.get("blocking"));
        }
        this.writeRef(writer, node, Element.HANDOFF_EXECUTOR, "handoff-executor");
        this.writeRef(writer, node, Element.THREAD_FACTORY, "thread-factory");
        this.writeThreads(writer, node, Element.MAX_THREADS);
        this.writeTime(writer, node, Element.KEEPALIVE_TIME);
        if (node.hasDefined("properties")) {
            this.writeProperties(writer, node.get("properties"));
        }
        writer.writeEndElement();
    }

    public void writeScheduledQueueThreadPool(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        this.writeScheduledQueueThreadPool(writer, node, Element.SCHEDULED_THREAD_POOL.getLocalName(), true);
    }

    public void writeScheduledQueueThreadPool(XMLExtendedStreamWriter writer, ModelNode node, String elementName, boolean includeName) throws XMLStreamException {
        writer.writeStartElement(elementName);
        if (includeName && node.hasDefined("name")) {
            this.writeAttribute(writer, Attribute.NAME, node.get("name"));
        }
        this.writeRef(writer, node, Element.THREAD_FACTORY, "thread-factory");
        this.writeThreads(writer, node, Element.MAX_THREADS);
        this.writeTime(writer, node, Element.KEEPALIVE_TIME);
        if (node.hasDefined("properties")) {
            this.writeProperties(writer, node.get("properties"));
        }
        writer.writeEndElement();
    }

    public void writeUnboundedQueueThreadPool(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        this.writeUnboundedQueueThreadPool(writer, node, Element.UNBOUNDED_QUEUE_THREAD_POOL.getLocalName(), true);
    }

    public void writeUnboundedQueueThreadPool(XMLExtendedStreamWriter writer, ModelNode node, String elementName, boolean includeName) throws XMLStreamException {
        writer.writeStartElement(elementName);
        if (includeName && node.hasDefined("name")) {
            this.writeAttribute(writer, Attribute.BLOCKING, node.get("name"));
        }
        this.writeRef(writer, node, Element.THREAD_FACTORY, "thread-factory");
        this.writeThreads(writer, node, Element.MAX_THREADS);
        this.writeTime(writer, node, Element.KEEPALIVE_TIME);
        if (node.hasDefined("properties")) {
            this.writeProperties(writer, node.get("properties"));
        }
        writer.writeEndElement();
    }

    private void writeRef(XMLExtendedStreamWriter writer, ModelNode node, Element element, String name) throws XMLStreamException {
        if (node.hasDefined(name)) {
            writer.writeStartElement(element.getLocalName());
            this.writeAttribute(writer, Attribute.NAME, node.get(name));
            writer.writeEndElement();
        }
    }

    private void writeThreads(XMLExtendedStreamWriter writer, ModelNode node, Element element) throws XMLStreamException {
        if (node.hasDefined(element.getLocalName())) {
            writer.writeStartElement(element.getLocalName());
            ModelNode threads = node.get(element.getLocalName());
            if (threads.hasDefined("count")) {
                this.writeAttribute(writer, Attribute.COUNT, threads.get("count"));
            }
            if (threads.hasDefined("per-cpu")) {
                this.writeAttribute(writer, Attribute.PER_CPU, threads.get("per-cpu"));
            }
            writer.writeEndElement();
        }
    }

    private void writeTime(XMLExtendedStreamWriter writer, ModelNode node, Element element) throws XMLStreamException {
        if (node.hasDefined(element.getLocalName())) {
            writer.writeStartElement(element.getLocalName());
            ModelNode keepalive = node.get(element.getLocalName());
            if (keepalive.hasDefined("time")) {
                this.writeAttribute(writer, Attribute.TIME, keepalive.get("time"));
            }
            if (keepalive.hasDefined("unit")) {
                this.writeAttribute(writer, Attribute.UNIT, keepalive.get("unit"));
            }
            writer.writeEndElement();
        }
    }

    private void writeProperties(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        writer.writeStartElement(Element.PROPERTIES.getLocalName());
        if (node.getType() == ModelType.LIST) {
            for (ModelNode prop : node.asList()) {
                if (prop.getType() != ModelType.PROPERTY) continue;
                writer.writeStartElement(Element.PROPERTY.getLocalName());
                Property property = prop.asProperty();
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                this.writeAttribute(writer, Attribute.VALUE, property.getValue());
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private void writeAttribute(XMLExtendedStreamWriter writer, Attribute attr, ModelNode value) throws XMLStreamException {
        writer.writeAttribute(attr.getLocalName(), value.asString());
    }
}

