/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractSubsystemElement;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.ChildElement;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.threads.AbstractExecutorElement;
import org.jboss.as.threads.Element;
import org.jboss.as.threads.Namespace;
import org.jboss.as.threads.ThreadFactoryAdd;
import org.jboss.as.threads.ThreadFactoryElement;
import org.jboss.as.threads.ThreadsSubsystemAdd;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public final class ThreadsSubsystemElement
extends AbstractSubsystemElement<ThreadsSubsystemElement> {
    private static final long serialVersionUID = -8577568464935736902L;
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.threads");
    private final NavigableMap<String, ThreadFactoryElement> threadFactories = new TreeMap<String, ThreadFactoryElement>();
    private final NavigableMap<String, ChildElement<? extends AbstractExecutorElement<?>>> executors = new TreeMap();

    protected ThreadsSubsystemElement() {
        super(Namespace.CURRENT.getUriString());
    }

    protected Class<ThreadsSubsystemElement> getElementClass() {
        return ThreadsSubsystemElement.class;
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        for (ThreadFactoryElement tfe : this.threadFactories.values()) {
            streamWriter.writeStartElement(Element.THREAD_FACTORY.getLocalName());
            tfe.writeContent(streamWriter);
        }
        for (ChildElement childElement : this.executors.values()) {
            streamWriter.writeStartElement(childElement.getLocalName());
            ((AbstractExecutorElement)childElement.getElement()).writeContent(streamWriter);
        }
        streamWriter.writeEndElement();
    }

    protected void getUpdates(List<? super AbstractSubsystemUpdate<ThreadsSubsystemElement, ?>> objects) {
        for (String name : this.threadFactories.keySet()) {
            objects.add(new ThreadFactoryAdd(name));
        }
        for (String name : this.executors.keySet()) {
            objects.add(((AbstractExecutorElement)((ChildElement)this.executors.get(name)).getElement()).getAdd());
        }
    }

    protected boolean isEmpty() {
        return this.threadFactories.isEmpty() && this.executors.isEmpty();
    }

    protected ThreadsSubsystemAdd getAdd() {
        return new ThreadsSubsystemAdd();
    }

    protected <P> void applyRemove(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
    }

    ThreadFactoryElement getThreadFactory(String name) {
        return (ThreadFactoryElement)((Object)this.threadFactories.get(name));
    }

    void removeThreadFactory(String name) {
        this.threadFactories.remove(name);
    }

    ThreadFactoryElement addThreadFactory(String name) {
        if (this.threadFactories.containsKey(name)) {
            return null;
        }
        ThreadFactoryElement element = new ThreadFactoryElement(name);
        this.threadFactories.put(name, element);
        return element;
    }

    AbstractExecutorElement<?> getExecutor(String name) {
        ChildElement childElement = (ChildElement)this.executors.get(name);
        return childElement == null ? null : (AbstractExecutorElement)childElement.getElement();
    }

    void removeExecutor(String name) {
        this.executors.remove(name);
    }

    void addExecutor(String name, ChildElement<? extends AbstractExecutorElement<?>> element) {
        this.executors.put(name, element);
    }
}

