/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.domain.management.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.test.integration.domain.management.util.DomainControllerClientConfig;
import org.jboss.as.test.integration.domain.management.util.DomainLifecycleUtil;
import org.jboss.as.test.integration.domain.management.util.JBossAsManagedConfiguration;
import org.jboss.as.test.integration.domain.management.util.JBossAsManagedConfigurationParameters;
import org.jboss.as.test.shared.FileUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.exporter.StreamExporter;
import org.junit.Assert;

public class DomainTestSupport {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.test.integration.domain");
    public static final String masterAddress = System.getProperty("jboss.test.host.master.address", "127.0.0.1");
    public static final String slaveAddress = System.getProperty("jboss.test.host.slave.address", "127.0.0.1");
    public static final long domainBootTimeout = Long.valueOf(System.getProperty("jboss.test.domain.boot.timeout", "60000"));
    public static final long domainShutdownTimeout = Long.valueOf(System.getProperty("jboss.test.domain.shutdown.timeout", "20000"));
    private final JBossAsManagedConfiguration masterConfiguration;
    private final JBossAsManagedConfiguration slaveConfiguration;
    private final DomainLifecycleUtil domainMasterLifecycleUtil;
    private final DomainLifecycleUtil domainSlaveLifecycleUtil;
    private final DomainControllerClientConfig sharedClientConfig;
    private final String testClass;

    public static JBossAsManagedConfiguration getMasterConfiguration(String domainConfigPath, String hostConfigPath, String testName, JBossAsManagedConfigurationParameters params) throws URISyntaxException {
        String hostName = "master";
        File domains = DomainTestSupport.getBaseDir(testName);
        File extraModules = DomainTestSupport.getAddedModulesDir(testName);
        File overrideModules = DomainTestSupport.getHostOverrideModulesDir(testName, "master");
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        JBossAsManagedConfiguration masterConfig = new JBossAsManagedConfiguration(params);
        DomainTestSupport.configureModulePath(masterConfig, overrideModules, extraModules);
        masterConfig.setHostControllerManagementAddress(masterAddress);
        masterConfig.setHostCommandLineProperties("-Djboss.test.host.master.address=" + masterAddress);
        URL url = tccl.getResource(domainConfigPath);
        assert (url != null) : "cannot find domainConfigPath";
        masterConfig.setDomainConfigFile(new File(url.toURI()).getAbsolutePath());
        System.out.println(masterConfig.getDomainConfigFile());
        url = tccl.getResource(hostConfigPath);
        assert (url != null) : "cannot find hostConfigPath";
        System.out.println(masterConfig.getHostConfigFile());
        masterConfig.setHostConfigFile(new File(url.toURI()).getAbsolutePath());
        File masterDir = new File(domains, "master");
        new File(masterDir, "configuration").mkdirs();
        masterConfig.setDomainDirectory(masterDir.getAbsolutePath());
        return masterConfig;
    }

    public static JBossAsManagedConfiguration getSlaveConfiguration(String hostConfigPath, String testName, JBossAsManagedConfigurationParameters params) throws URISyntaxException {
        String hostName = "slave";
        File domains = DomainTestSupport.getBaseDir(testName);
        File extraModules = DomainTestSupport.getAddedModulesDir(testName);
        File overrideModules = DomainTestSupport.getHostOverrideModulesDir(testName, "slave");
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        JBossAsManagedConfiguration slaveConfig = new JBossAsManagedConfiguration(params);
        DomainTestSupport.configureModulePath(slaveConfig, overrideModules, extraModules);
        slaveConfig.setHostName("slave");
        slaveConfig.setHostControllerManagementAddress(slaveAddress);
        slaveConfig.setHostControllerManagementPort(19999);
        slaveConfig.setHostCommandLineProperties("-Djboss.test.host.master.address=" + masterAddress + " -Djboss.test.host.slave.address=" + slaveAddress);
        URL url = tccl.getResource(hostConfigPath);
        slaveConfig.setHostConfigFile(new File(url.toURI()).getAbsolutePath());
        System.out.println(slaveConfig.getHostConfigFile());
        File slaveDir = new File(domains, "slave");
        new File(slaveDir, "configuration").mkdirs();
        slaveConfig.setDomainDirectory(slaveDir.getAbsolutePath());
        System.out.println(slaveConfig.getDomainDirectory());
        return slaveConfig;
    }

    public static void startHosts(long timeout, DomainLifecycleUtil ... hosts) throws Exception {
        Future[] futures = new Future[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            futures[i] = hosts[i].startAsync();
        }
        DomainTestSupport.processFutures(futures, timeout);
    }

    public static void stopHosts(long timeout, DomainLifecycleUtil ... hosts) throws Exception {
        Future[] futures = new Future[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            futures[i] = hosts[i].stopAsync();
        }
        DomainTestSupport.processFutures(futures, timeout);
    }

    public static File getBaseDir(String testName) {
        return new File("target" + File.separator + "domains" + File.separator + testName);
    }

    public static File getHostDir(String testName, String hostName) {
        return new File(DomainTestSupport.getBaseDir(testName), hostName);
    }

    public static File getAddedModulesDir(String testName) {
        File f = new File(DomainTestSupport.getBaseDir(testName), "added-modules");
        f.mkdirs();
        return f;
    }

    public static File getHostOverrideModulesDir(String testName, String hostName) {
        File f = new File(DomainTestSupport.getHostDir(testName, hostName), "added-modules");
        f.mkdirs();
        return f;
    }

    public static ModelNode createOperationNode(String address, String operation) {
        ModelNode op = new ModelNode();
        ModelNode list = op.get("address").setEmptyList();
        if (address != null) {
            String[] pathSegments;
            for (String segment : pathSegments = address.split("/")) {
                String[] elements = segment.split("=");
                list.add(elements[0], elements[1]);
            }
        }
        op.get("operation").set(operation);
        return op;
    }

    public static ModelNode validateResponse(ModelNode response) {
        return DomainTestSupport.validateResponse(response, true);
    }

    public static ModelNode validateResponse(ModelNode response, boolean getResult) {
        if (!"success".equals(response.get("outcome").asString())) {
            System.out.println("Failed response:");
            System.out.println(response);
            Assert.fail((String)response.get("failure-description").toString());
        }
        if (getResult) {
            Assert.assertTrue((String)"result exists", (boolean)response.has("result"));
            return response.get("result");
        }
        return null;
    }

    public static ModelNode validateFailedResponse(ModelNode response) {
        if (!"failed".equals(response.get("outcome").asString())) {
            System.out.println("Response succeeded:");
            System.out.println(response);
            Assert.fail((String)response.get("outcome").toString());
        }
        Assert.assertTrue((String)"failure description exists", (boolean)response.has("failure-description"));
        return response.get("failure-description");
    }

    public static void cleanFile(File file) {
        if (file != null && file.exists()) {
            if (file.isDirectory()) {
                for (File child : file.listFiles()) {
                    DomainTestSupport.cleanFile(child);
                }
            }
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }
    }

    public static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                log.errorf(t, "Failed to close resource %s", (Object)closeable);
            }
        }
    }

    private static void processFutures(Future<?>[] futures, long timeout) throws Exception {
        try {
            for (int i = 0; i < futures.length; ++i) {
                try {
                    futures[i].get(timeout, TimeUnit.MILLISECONDS);
                    continue;
                }
                catch (ExecutionException e) {
                    throw e.getCause();
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static void configureModulePath(JBossAsManagedConfiguration config, File ... extraModules) {
        String basePath = config.getModulePath();
        if (basePath == null || basePath.isEmpty()) {
            basePath = config.getJbossHome() + File.separatorChar + "modules";
        }
        StringBuilder path = new StringBuilder();
        for (File extraModule : extraModules) {
            path.append(extraModule.getAbsolutePath()).append(File.pathSeparatorChar);
        }
        path.append(basePath);
        config.setModulePath(path.toString());
    }

    protected DomainTestSupport(String testClass, String domainConfig, String masterConfig, String slaveConfig, JBossAsManagedConfigurationParameters masterParams, JBossAsManagedConfigurationParameters slaveParams) throws Exception {
        this.testClass = testClass;
        this.sharedClientConfig = DomainControllerClientConfig.create();
        this.masterConfiguration = DomainTestSupport.getMasterConfiguration(domainConfig, masterConfig, testClass, masterParams);
        this.domainMasterLifecycleUtil = new DomainLifecycleUtil(this.masterConfiguration, this.sharedClientConfig);
        if (slaveConfig != null) {
            this.slaveConfiguration = DomainTestSupport.getSlaveConfiguration(slaveConfig, testClass, slaveParams);
            this.domainSlaveLifecycleUtil = new DomainLifecycleUtil(this.slaveConfiguration, this.sharedClientConfig);
        } else {
            this.slaveConfiguration = null;
            this.domainSlaveLifecycleUtil = null;
        }
    }

    public static DomainTestSupport create(String testClass, Configuration configuration) throws Exception {
        return new DomainTestSupport(testClass, configuration.getDomainConfig(), configuration.getMasterConfig(), configuration.getSlaveConfigs(), configuration.getMasterConfigurationParameters(), configuration.getSlaveConfigurationParameters());
    }

    public static DomainTestSupport create(String testClass, String domainConfig, String masterConfig, String slaveConfig, JBossAsManagedConfigurationParameters masterParams, JBossAsManagedConfigurationParameters slaveParams) throws Exception {
        return new DomainTestSupport(testClass, domainConfig, masterConfig, slaveConfig, masterParams, slaveParams);
    }

    public JBossAsManagedConfiguration getDomainMasterConfiguration() {
        return this.masterConfiguration;
    }

    public DomainLifecycleUtil getDomainMasterLifecycleUtil() {
        return this.domainMasterLifecycleUtil;
    }

    public JBossAsManagedConfiguration getDomainSlaveConfiguration() {
        return this.slaveConfiguration;
    }

    public DomainLifecycleUtil getDomainSlaveLifecycleUtil() {
        return this.domainSlaveLifecycleUtil;
    }

    public void start() {
        this.domainMasterLifecycleUtil.start();
        if (this.domainSlaveLifecycleUtil != null) {
            this.domainSlaveLifecycleUtil.start();
        }
    }

    public void addTestModule(String moduleName, InputStream moduleXml, Map<String, StreamExporter> contents) throws IOException {
        File modulesDir = DomainTestSupport.getAddedModulesDir(this.testClass);
        DomainTestSupport.addModule(modulesDir, moduleName, moduleXml, contents);
    }

    public void addOverrideModule(String hostName, String moduleName, InputStream moduleXml, Map<String, StreamExporter> contents) throws IOException {
        File modulesDir = DomainTestSupport.getHostOverrideModulesDir(this.testClass, hostName);
        DomainTestSupport.addModule(modulesDir, moduleName, moduleXml, contents);
    }

    static void addModule(File modulesDir, String moduleName, InputStream moduleXml, Map<String, StreamExporter> resources) throws IOException {
        String modulePath = moduleName.replace('.', File.separatorChar) + File.separatorChar + "main";
        File moduleDir = new File(modulesDir, modulePath);
        moduleDir.mkdirs();
        FileUtils.copyFile(moduleXml, new File(moduleDir, "module.xml"));
        for (Map.Entry<String, StreamExporter> entry : resources.entrySet()) {
            entry.getValue().exportTo(new File(moduleDir, entry.getKey()), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            try {
                if (this.domainSlaveLifecycleUtil != null) {
                    this.domainSlaveLifecycleUtil.stop();
                }
            }
            finally {
                this.domainMasterLifecycleUtil.stop();
            }
        }
        finally {
            StreamUtils.safeClose((Closeable)this.sharedClientConfig);
        }
    }

    public static class Configuration {
        private String domainConfig;
        private String masterConfig;
        private String slaveConfig;
        private JBossAsManagedConfigurationParameters masterParams;
        private JBossAsManagedConfigurationParameters slaveParams;

        protected Configuration(String domainConfig, String masterConfig, String slaveConfig, JBossAsManagedConfigurationParameters masterParams, JBossAsManagedConfigurationParameters slaveParams) {
            this.domainConfig = domainConfig;
            this.masterConfig = masterConfig;
            this.slaveConfig = slaveConfig;
            this.masterParams = masterParams;
            this.slaveParams = slaveParams;
        }

        public String getDomainConfig() {
            return this.domainConfig;
        }

        public String getMasterConfig() {
            return this.masterConfig;
        }

        public String getSlaveConfigs() {
            return this.slaveConfig;
        }

        public JBossAsManagedConfigurationParameters getMasterConfigurationParameters() {
            return this.slaveParams;
        }

        public JBossAsManagedConfigurationParameters getSlaveConfigurationParameters() {
            return this.slaveParams;
        }

        public static Configuration create(String domainConfig, String masterConfig, String slaveConfig, JBossAsManagedConfigurationParameters masterParams, JBossAsManagedConfigurationParameters slaveParams) {
            return new Configuration(domainConfig, masterConfig, slaveConfig, masterParams, slaveParams);
        }
    }
}

