/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.util.Base64;

public class HttpRequest {
    private static String execute(Callable<String> task, long timeout, TimeUnit unit) throws TimeoutException, IOException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<String> result = executor.submit(task);
        try {
            String string = result.get(timeout, unit);
            return string;
        }
        catch (TimeoutException e) {
            result.cancel(true);
            throw e;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        finally {
            executor.shutdownNow();
            try {
                executor.awaitTermination(timeout, unit);
            }
            catch (InterruptedException e) {}
        }
    }

    public static String get(String spec, long timeout, TimeUnit unit) throws IOException, ExecutionException, TimeoutException {
        final URL url = new URL(spec);
        Callable<String> task = new Callable<String>(){

            @Override
            public String call() throws Exception {
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setDoInput(true);
                return HttpRequest.processResponse(conn);
            }
        };
        return HttpRequest.execute(task, timeout, unit);
    }

    public static String get(String spec, final long waitUntilAvailableMs, long responseTimeout, TimeUnit responseTimeoutUnit) throws IOException, ExecutionException, TimeoutException {
        final URL url = new URL(spec);
        Callable<String> task = new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() throws Exception {
                long startTime = System.currentTimeMillis();
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setDoInput(true);
                while (conn.getResponseCode() == 404 && System.currentTimeMillis() - startTime < waitUntilAvailableMs) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    finally {
                        conn = (HttpURLConnection)url.openConnection();
                        conn.setDoInput(true);
                    }
                }
                return HttpRequest.processResponse(conn);
            }
        };
        return HttpRequest.execute(task, responseTimeout, responseTimeoutUnit);
    }

    public static String get(String spec, final String username, final String password, long timeout, TimeUnit unit) throws IOException, TimeoutException {
        final URL url = new URL(spec);
        Callable<String> task = new Callable<String>(){

            @Override
            public String call() throws IOException {
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                if (username != null) {
                    String userpassword = username + ":" + password;
                    String basicAuthorization = Base64.encodeBytes((byte[])userpassword.getBytes());
                    conn.setRequestProperty("Authorization", "Basic " + basicAuthorization);
                }
                conn.setDoInput(true);
                return HttpRequest.processResponse(conn);
            }
        };
        return HttpRequest.execute(task, timeout, unit);
    }

    private static String read(InputStream in) throws IOException {
        int b;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((b = in.read()) != -1) {
            out.write(b);
        }
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String processResponse(HttpURLConnection conn) throws IOException {
        int responseCode = conn.getResponseCode();
        if (responseCode != 200) {
            InputStream err = conn.getErrorStream();
            try {
                throw new IOException(HttpRequest.read(err));
            }
            catch (Throwable throwable) {
                err.close();
                throw throwable;
            }
        }
        InputStream in = conn.getInputStream();
        try {
            String string = HttpRequest.read(in);
            return string;
        }
        finally {
            in.close();
        }
    }

    public static String put(String spec, String message, long timeout, TimeUnit unit) throws MalformedURLException, ExecutionException, TimeoutException {
        return HttpRequest.execRequestMethod(spec, message, timeout, unit, "PUT");
    }

    private static String execRequestMethod(String spec, final String message, long timeout, TimeUnit unit, final String requestMethod) throws MalformedURLException, ExecutionException, TimeoutException {
        if (requestMethod == null || requestMethod.isEmpty()) {
            throw new IllegalArgumentException("Request Method must be specified (ie. GET, PUT, DELETE etc)");
        }
        final URL url = new URL(spec);
        Callable<String> task = new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() throws Exception {
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setDoInput(true);
                conn.setDoOutput(true);
                conn.setRequestMethod(requestMethod);
                OutputStream out = conn.getOutputStream();
                try {
                    HttpRequest.write(out, message);
                    String string = HttpRequest.processResponse(conn);
                    return string;
                }
                finally {
                    out.close();
                }
            }
        };
        try {
            return HttpRequest.execute(task, timeout, unit);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String post(String spec, String message, long timeout, TimeUnit unit) throws MalformedURLException, ExecutionException, TimeoutException {
        return HttpRequest.execRequestMethod(spec, message, timeout, unit, "POST");
    }

    public static String delete(String spec, String message, long timeout, TimeUnit unit) throws MalformedURLException, ExecutionException, TimeoutException {
        return HttpRequest.execRequestMethod(spec, message, timeout, unit, "DELETE");
    }

    public static String head(String spec, String message, long timeout, TimeUnit unit) throws MalformedURLException, ExecutionException, TimeoutException {
        return HttpRequest.execRequestMethod(spec, message, timeout, unit, "HEAD");
    }

    private static void write(OutputStream out, String message) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        writer.write(message);
        writer.flush();
    }
}

