/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.management;

import java.util.HashSet;
import java.util.List;
import org.jboss.as.test.integration.management.Connector;
import org.jboss.as.test.integration.management.base.AbstractMgmtTestBase;
import org.jboss.as.test.integration.management.util.ModelUtil;
import org.jboss.as.test.integration.management.util.WebUtil;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;

public class ServerManager
extends AbstractMgmtTestBase {
    private int mgmtPort;
    private String mgmtHostName;

    public ServerManager() {
        this("localhost", 9999);
    }

    public ServerManager(String mgmtHostName, int mgmtPort) {
        this.mgmtHostName = mgmtHostName;
        this.mgmtPort = mgmtPort;
    }

    public ServerManager(String mgmtHostName) {
        this.mgmtHostName = mgmtHostName;
        this.mgmtPort = 9999;
    }

    public int getMgmtPort() {
        return this.mgmtPort;
    }

    public void addConnector(Connector conn, int port, String keyPEMFile, String certPEMFile, String keyStoreFile, String password) throws Exception {
        ModelNode op = this.getAddSocketBindingOp(conn, port);
        ServerManager.executeOperation(op);
        op = this.getAddConnectorOp(conn, keyPEMFile, certPEMFile, keyStoreFile, password);
        ServerManager.executeOperation(op);
        Assert.assertTrue((boolean)this.getConnectorList().contains("test-" + conn.getName() + "-connector"));
    }

    private ModelNode getAddSocketBindingOp(Connector conn, int port) {
        ModelNode op = ModelUtil.createOpNode("socket-binding-group=standard-sockets/socket-binding=test-" + conn.getName(), "add");
        op.get("port").set(port);
        return op;
    }

    private ModelNode getAddConnectorOp(Connector conn, String keyPEMFile, String certPEMFile, String keyStoreFile, String password) {
        ModelNode op = ModelUtil.createOpNode("subsystem=web/connector=test-" + conn.getName() + "-connector", "add");
        op.get("socket-binding").set("test-" + conn.getName());
        op.get("scheme").set(conn.getScheme());
        op.get("protocol").set(conn.getProtrocol());
        op.get("secure").set(conn.isSecure());
        op.get("enabled").set(true);
        if (conn.isSecure()) {
            ModelNode ssl = new ModelNode();
            if (conn.equals((Object)Connector.HTTPSNATIVE)) {
                ssl.get("certificate-key-file").set(keyPEMFile);
                ssl.get("certificate-file").set(certPEMFile);
            } else {
                ssl.get("certificate-key-file").set(keyStoreFile);
            }
            ssl.get("password").set(password);
            op.get("ssl").set(ssl);
        }
        return op;
    }

    public void removeConnector(Connector conn, String checkURL) throws Exception {
        ModelNode op = this.getRemoveConnectorOp(conn);
        ServerManager.executeOperation(op);
        Thread.sleep(5000L);
        if (checkURL != null) {
            Assert.assertFalse((String)"Connector not removed.", (boolean)WebUtil.testHttpURL(checkURL));
        }
        op = this.getRemoveSocketBindingOp(conn);
        ServerManager.executeOperation(op);
    }

    private ModelNode getRemoveSocketBindingOp(Connector conn) {
        ModelNode op = ModelUtil.createOpNode("socket-binding-group=standard-sockets/socket-binding=test-" + conn.getName(), "remove");
        return op;
    }

    private ModelNode getRemoveConnectorOp(Connector conn) {
        ModelNode op = ModelUtil.createOpNode("subsystem=web/connector=test-" + conn.getName() + "-connector", "remove");
        return op;
    }

    public HashSet<String> getConnectorList() throws Exception {
        ModelNode op = ModelUtil.createOpNode("subsystem=web", "read-children-names");
        op.get("child-type").set("connector");
        ModelNode result = ServerManager.executeOperation(op);
        List connectors = result.asList();
        HashSet<String> connNames = new HashSet<String>();
        for (ModelNode n : connectors) {
            connNames.add(n.asString());
        }
        return connNames;
    }

    public void initModelControllerClient() {
        ServerManager.initModelControllerClient(this.mgmtHostName, this.getMgmtPort());
    }
}

