/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.smoke.modular.utils;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.as.protocol.StreamUtils;

public class PollingUtils {
    public static void retryWithTimeout(long timeoutMs, Task task) throws Exception {
        long end = System.currentTimeMillis() + timeoutMs;
        do {
            if (task.execute()) {
                return;
            }
            Thread.sleep(100L);
        } while (System.currentTimeMillis() < end);
        throw new RuntimeException("Task could not be completed within " + timeoutMs + "ms");
    }

    public static class UrlConnectionTask
    implements Task {
        private final URL url;
        private String response;
        private final String request;

        public UrlConnectionTask(URL url) {
            this.url = url;
            this.request = null;
        }

        public UrlConnectionTask(URL url, String request) {
            this.url = url;
            this.request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute() throws Exception {
            boolean bl;
            BufferedInputStream in;
            block8: {
                URLConnection conn = null;
                in = null;
                OutputStreamWriter osw = null;
                try {
                    conn = this.url.openConnection();
                    conn.setDoInput(true);
                    if (this.request != null) {
                        conn.setDoOutput(true);
                        osw = new OutputStreamWriter(conn.getOutputStream());
                        osw.write(this.request);
                        osw.flush();
                    }
                    in = new BufferedInputStream(conn.getInputStream());
                    int i = ((InputStream)in).read();
                    StringBuilder sb = new StringBuilder();
                    while (i != -1) {
                        sb.append((char)i);
                        i = ((InputStream)in).read();
                    }
                    this.response = sb.toString();
                    bl = true;
                    if (osw == null) break block8;
                }
                catch (Exception e) {
                    boolean bl2 = false;
                    return bl2;
                }
                finally {
                    if (osw != null) {
                        StreamUtils.safeClose(osw);
                    }
                    StreamUtils.safeClose(in);
                }
                StreamUtils.safeClose((Closeable)osw);
            }
            StreamUtils.safeClose((Closeable)in);
            return bl;
        }

        public String getResponse() {
            return this.response;
        }
    }

    public static class JndiLookupTask
    implements Task {
        private final Context context;
        private final String name;
        private Object result;

        public JndiLookupTask(Context context, String name) {
            this.context = context;
            this.name = name;
        }

        @Override
        public boolean execute() throws Exception {
            try {
                this.result = this.context.lookup(this.name);
            }
            catch (NamingException e) {
                return false;
            }
            return true;
        }

        public <T> T getResult(Class<T> clazz) {
            return clazz.cast(this.result);
        }
    }

    public static class WaitForMBeanTask
    implements Task {
        private final MBeanServerConnection server;
        private final ObjectName name;

        public WaitForMBeanTask(MBeanServerConnection server, ObjectName name) {
            this.server = server;
            this.name = name;
        }

        @Override
        public boolean execute() throws Exception {
            try {
                return this.server.getMBeanInfo(this.name) != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static interface Task {
        public boolean execute() throws Exception;
    }
}

