/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.test;

import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import junit.framework.Assert;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

final class TestParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<ModelMarshallingContext> {
    String mainSubsystemName;

    TestParser(String mainSubsystemName) {
        this.mainSubsystemName = mainSubsystemName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeContent(XMLExtendedStreamWriter writer, ModelMarshallingContext context) throws XMLStreamException {
        String defaultNamespace = writer.getNamespaceContext().getNamespaceURI("");
        try {
            XMLElementWriter subsystemWriter;
            ModelNode subsystem = context.getModelNode().get(new String[]{"subsystem", this.mainSubsystemName});
            if (subsystem.isDefined() && (subsystemWriter = context.getSubsystemWriter(this.mainSubsystemName)) != null) {
                subsystemWriter.writeContent(writer, (Object)new SubsystemMarshallingContext(subsystem, writer));
            }
        }
        catch (Throwable t) {
            Assert.fail((String)("could not marshal subsystem xml " + t));
        }
        finally {
            writer.setDefaultNamespace(defaultNamespace);
        }
        writer.writeEndDocument();
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            if (Namespace.forUri((String)reader.getNamespaceURI()) != Namespace.UNKNOWN) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            if (Element.forName((String)reader.getLocalName()) != Element.SUBSYSTEM) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            reader.handleAny(operations);
        }
    }
}

