/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.operations.validation.OperationValidator;
import org.jboss.as.controller.persistence.SubsystemXmlWriterRegistry;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationTransformerRegistry;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.as.server.Services;
import org.jboss.as.subsystem.test.AbstractSubsystemTest;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.ControllerInitializer;
import org.jboss.as.subsystem.test.StringConfigurationPersister;
import org.jboss.as.subsystem.test.TestModelControllerService;
import org.jboss.as.subsystem.test.TestParser;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceTarget;

public class KernelServices {
    private volatile ServiceContainer container;
    private final ModelController controller;
    private final StringConfigurationPersister persister;
    private final OperationValidator operationValidator;
    private final String mainSubsystemName;
    private final ManagementResourceRegistration rootRegistration;
    private final Map<ModelVersion, KernelServices> legacyServices;
    private final ExtensionRegistry extensionRegistry;
    private final ModelVersion legacyModelVersion;
    private final boolean successfulBoot;
    private final Throwable bootError;
    private static final AtomicInteger counter = new AtomicInteger();

    private KernelServices(ServiceContainer container, ModelController controller, StringConfigurationPersister persister, ManagementResourceRegistration rootRegistration, OperationValidator operationValidator, String mainSubsystemName, ExtensionRegistry extensionRegistry, ModelVersion legacyModelVersion, boolean successfulBoot, Throwable bootError) {
        this.container = container;
        this.controller = controller;
        this.persister = persister;
        this.operationValidator = operationValidator;
        this.mainSubsystemName = mainSubsystemName;
        this.rootRegistration = rootRegistration;
        this.legacyServices = legacyModelVersion != null ? null : new HashMap();
        this.extensionRegistry = extensionRegistry;
        this.legacyModelVersion = legacyModelVersion;
        this.successfulBoot = successfulBoot;
        this.bootError = bootError;
    }

    static KernelServices create(String mainSubsystemName, AdditionalInitialization additionalInit, ExtensionRegistry controllerExtensionRegistry, List<ModelNode> bootOperations, TestParser testParser, Extension mainExtension, ModelVersion legacyModelVersion) throws Exception {
        ControllerInitializer controllerInitializer = additionalInit.createControllerInitializer();
        PathManagerService pathManager = new PathManagerService(){};
        controllerInitializer.setPathManger(pathManager);
        additionalInit.setupController(controllerInitializer);
        ServiceContainer container = ServiceContainer.Factory.create((String)("test" + counter.incrementAndGet()));
        ServiceTarget target = container.subTarget();
        ControlledProcessState processState = new ControlledProcessState(true);
        List<ModelNode> extraOps = controllerInitializer.initializeBootOperations();
        ArrayList<ModelNode> allOps = new ArrayList<ModelNode>();
        if (extraOps != null) {
            allOps.addAll(extraOps);
        }
        allOps.addAll(bootOperations);
        StringConfigurationPersister persister = new StringConfigurationPersister(allOps, testParser);
        controllerExtensionRegistry.setWriterRegistry((SubsystemXmlWriterRegistry)persister);
        controllerExtensionRegistry.setPathManager((PathManager)pathManager);
        TestModelControllerService svc = new TestModelControllerService(mainExtension, controllerInitializer, additionalInit, controllerExtensionRegistry, processState, persister, additionalInit.isValidateOperations());
        ServiceBuilder builder = target.addService(Services.JBOSS_SERVER_CONTROLLER, (Service)svc);
        builder.install();
        target.addService(PathManagerService.SERVICE_NAME, (Service)pathManager).install();
        additionalInit.addExtraServices(target);
        svc.waitForSetup();
        ModelController controller = svc.getValue();
        processState.setRunning();
        KernelServices kernelServices = new KernelServices(container, controller, persister, svc.getRootRegistration(), new OperationValidator((ImmutableManagementResourceRegistration)svc.getRootRegistration()), mainSubsystemName, controllerExtensionRegistry, legacyModelVersion, svc.isSuccessfulBoot(), svc.getBootError());
        return kernelServices;
    }

    public boolean isSuccessfulBoot() {
        return this.successfulBoot;
    }

    public Throwable getBootError() {
        return this.bootError;
    }

    public KernelServices getLegacyServices(ModelVersion modelVersion) {
        if (this.legacyServices == null) {
            throw new IllegalStateException("Can only be called for the main controller");
        }
        KernelServices legacy = this.legacyServices.get(modelVersion);
        if (legacy == null) {
            throw new IllegalStateException("No legacy subsystem controller was found for model version " + modelVersion);
        }
        return legacy;
    }

    public ServiceContainer getContainer() {
        return this.container;
    }

    public ModelNode executeOperation(ModelNode operation) {
        return this.controller.execute(operation, null, ModelController.OperationTransactionControl.COMMIT, null);
    }

    public ModelNode executeOperation(ModelVersion modelVersion, OperationTransformer.TransformedOperation op) {
        OperationResultTransformer resultTransformer;
        if (this.legacyServices == null) {
            throw new IllegalStateException("Can only be called for the main controller");
        }
        KernelServices legacy = this.legacyServices.get(modelVersion);
        if (legacy == null) {
            throw new IllegalStateException("No legacy subsystem controller was found for model version " + modelVersion);
        }
        ModelNode result = new ModelNode();
        if (op.getTransformedOperation() != null) {
            result = legacy.executeOperation(op.getTransformedOperation());
        }
        if ((resultTransformer = op.getResultTransformer()) != null) {
            result = resultTransformer.transformResult(result);
        }
        return result;
    }

    public OperationTransformer.TransformedOperation transformOperation(ModelVersion modelVersion, ModelNode operation) throws OperationFailedException {
        if (this.legacyServices == null) {
            throw new IllegalStateException("Can only be called for the main controller");
        }
        PathElement pathElement = PathElement.pathElement((String)"subsystem", (String)this.mainSubsystemName);
        PathAddress opAddr = PathAddress.pathAddress((ModelNode)operation.get("address"));
        if (opAddr.size() > 0 && opAddr.getElement(0).equals(pathElement)) {
            TransformerRegistry transformerRegistry = this.extensionRegistry.getTransformerRegistry();
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            OperationTransformerRegistry registry = transformerRegistry.resolveServer(modelVersion, this.createSubsystemVersionRegistry(modelVersion));
            TransformationContext transformationContext = null;
            return registry.resolveOperationTransformer(address, operation.get("operation").asString()).getTransformer().transformOperation(transformationContext, address, operation);
        }
        return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
    }

    public ModelNode executeForResult(ModelNode operation) throws OperationFailedException {
        ModelNode rsp = this.executeOperation(operation);
        if ("failed".equals(rsp.get("outcome").asString())) {
            throw new OperationFailedException(rsp.get("failure-description"));
        }
        return rsp.get("result");
    }

    public void executeForFailure(ModelNode operation) {
        try {
            this.executeForResult(operation);
            Assert.fail((String)"Should have given error");
        }
        catch (OperationFailedException operationFailedException) {
            // empty catch block
        }
    }

    public String getPersistedSubsystemXml() {
        return this.persister.getMarshalled();
    }

    public ModelNode readWholeModel() {
        ModelNode op = new ModelNode();
        op.get("operation").set("read-resource");
        op.get("address").set(PathAddress.EMPTY_ADDRESS.toModelNode());
        op.get("recursive").set(true);
        ModelNode result = this.executeOperation(op);
        return AbstractSubsystemTest.checkResultAndGetContents(result);
    }

    public ModelNode readTransformedModel(ModelVersion modelVersion) {
        if (this.legacyServices == null) {
            throw new IllegalStateException("Can only be called for the main controller");
        }
        ModelNode op = new ModelNode();
        op.get("operation").set("read-transformed-resource");
        op.get("address").set(PathAddress.EMPTY_ADDRESS.toModelNode());
        op.get("recursive").set(true);
        op.get("subsystem").set(this.mainSubsystemName);
        op.get("management-major-version").set(modelVersion.getMajor());
        op.get("management-minor-version").set(modelVersion.getMinor());
        op.get("management-micro-version").set(modelVersion.getMicro());
        ModelNode result = this.executeOperation(op);
        return AbstractSubsystemTest.checkResultAndGetContents(result);
    }

    public void validateOperations(List<ModelNode> operations) {
        this.operationValidator.validateOperations(operations);
    }

    public void validateOperation(ModelNode operation) {
        this.operationValidator.validateOperation(operation);
    }

    public void shutdown() {
        if (this.container != null) {
            this.container.shutdown();
            try {
                this.container.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.container = null;
            if (this.legacyServices != null) {
                for (KernelServices legacyService : this.legacyServices.values()) {
                    legacyService.shutdown();
                }
            }
        }
    }

    ManagementResourceRegistration getRootRegistration() {
        return this.rootRegistration;
    }

    ExtensionRegistry getExtensionRegistry() {
        return this.extensionRegistry;
    }

    void addLegacyKernelService(ModelVersion modelVersion, KernelServices legacyServices) {
        this.legacyServices.put(modelVersion, legacyServices);
    }

    private ModelNode createSubsystemVersionRegistry(ModelVersion modelVersion) {
        ModelNode subsystems = new ModelNode();
        subsystems.get(this.mainSubsystemName).set(modelVersion.toString());
        return subsystems;
    }
}

