/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.test;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class OperationValidator {
    private final ManagementResourceRegistration root;

    OperationValidator(ManagementResourceRegistration root) {
        this.root = root;
    }

    void validateOperations(List<ModelNode> operations) {
        if (operations == null) {
            return;
        }
        for (ModelNode operation : operations) {
            this.validateOperation(operation);
        }
    }

    void validateOperation(ModelNode operation) {
        if (operation == null) {
            return;
        }
        DescriptionProvider provider = this.getDescriptionProvider(operation);
        ModelNode description = provider.getModelDescription(null);
        Map<String, ModelNode> describedProperties = this.getDescribedRequestProperties(description);
        Map<String, ModelNode> actualParams = this.getActualRequestProperties(operation);
        this.checkActualOperationParamsAreDescribed(description, operation, describedProperties, actualParams);
        this.checkAllRequiredPropertiesArePresent(description, operation, describedProperties, actualParams);
        this.checkParameterTypes(description, operation, describedProperties, actualParams);
    }

    private Map<String, ModelNode> getDescribedRequestProperties(ModelNode description) {
        HashMap<String, ModelNode> requestProperties = new HashMap<String, ModelNode>();
        if (description.hasDefined("request-properties")) {
            for (String key : description.get("request-properties").keys()) {
                ModelNode desc = description.get(new String[]{"request-properties", key});
                Assert.assertTrue((String)("Undefined request property '" + key + "' in " + description), (boolean)desc.isDefined());
                requestProperties.put(key, desc);
            }
        }
        return requestProperties;
    }

    private Map<String, ModelNode> getActualRequestProperties(ModelNode operation) {
        HashMap<String, ModelNode> requestProperties = new HashMap<String, ModelNode>();
        for (String key : operation.keys()) {
            if (key.equals("operation") || key.equals("address") || key.equals("operation-headers")) continue;
            requestProperties.put(key, operation.get(key));
        }
        return requestProperties;
    }

    private void checkActualOperationParamsAreDescribed(ModelNode description, ModelNode operation, Map<String, ModelNode> describedProperties, Map<String, ModelNode> actualParams) {
        for (String paramName : actualParams.keySet()) {
            ModelNode param = actualParams.get(paramName);
            if (!param.isDefined()) continue;
            if (param.getType() == ModelType.OBJECT && param.keys().isEmpty()) {
                return;
            }
            if (describedProperties.containsKey(paramName)) continue;
            Assert.fail((String)("Operation " + operation + " contains a parameter '" + paramName + "' which does not appear in the description " + description));
        }
    }

    private void checkAllRequiredPropertiesArePresent(ModelNode description, ModelNode operation, Map<String, ModelNode> describedProperties, Map<String, ModelNode> actualParams) {
        for (String paramName : describedProperties.keySet()) {
            boolean required;
            ModelNode described = describedProperties.get(paramName);
            if (described.hasDefined("required")) {
                Assert.assertEquals((String)("'required' for '" + paramName + "' must be a boolean in " + description), (Object)ModelType.BOOLEAN, (Object)described.get("required").getType());
                required = described.get("required").asBoolean();
            } else {
                required = true;
            }
            List alternatives = null;
            if (described.hasDefined("alternatives")) {
                alternatives = described.get("alternatives").asList();
            }
            boolean exist = actualParams.containsKey(paramName);
            if (required && !exist && !OperationValidator.hasAlternative(actualParams.keySet(), alternatives)) {
                Assert.fail((String)("Required parameter '" + paramName + "' is not present in " + operation));
            }
            if (!exist || !OperationValidator.hasAlternative(actualParams.keySet(), alternatives)) continue;
            Assert.fail((String)("Alternative parameter for '" + paramName + "' is present in " + operation));
        }
    }

    private void checkParameterTypes(ModelNode description, ModelNode operation, Map<String, ModelNode> describedProperties, Map<String, ModelNode> actualParams) {
        for (String paramName : actualParams.keySet()) {
            ModelType modelType;
            ModelNode value = actualParams.get(paramName);
            if (!value.isDefined()) continue;
            if (value.getType() == ModelType.OBJECT && value.keys().isEmpty()) {
                return;
            }
            ModelNode typeNode = describedProperties.get(paramName).get("type");
            Assert.assertTrue((String)("No type for param '" + paramName + "' in " + description), (boolean)typeNode.isDefined());
            try {
                modelType = Enum.valueOf(ModelType.class, typeNode.asString());
            }
            catch (Exception e) {
                Assert.fail((String)("Could not determine type for param '" + paramName + "' in " + description));
                return;
            }
            try {
                this.checkType(modelType, value);
            }
            catch (IllegalArgumentException e) {
                Assert.fail((String)("Could not convert '" + paramName + "' to a " + modelType + " in " + operation));
            }
            this.checkRange(operation, paramName, modelType, describedProperties.get(paramName), value);
            this.checkList(operation, paramName, modelType, describedProperties.get(paramName), value);
        }
    }

    private void checkRange(ModelNode operation, String paramName, ModelType modelType, ModelNode describedProperty, ModelNode value) {
        int minLength;
        if (!value.isDefined()) {
            return;
        }
        if (describedProperty.hasDefined("min")) {
            switch (modelType) {
                case BIG_DECIMAL: {
                    Assert.assertFalse((String)(paramName + ":" + value.asBigDecimal() + " is smaller than min " + describedProperty.get("min").asBigDecimal() + " for " + operation), (value.asBigDecimal().compareTo(describedProperty.get("min").asBigDecimal()) == -1 ? 1 : 0) != 0);
                    break;
                }
                case BIG_INTEGER: {
                    Assert.assertFalse((String)(paramName + ":" + value.asBigInteger() + " is smaller than min " + describedProperty.get("min").asBigInteger() + " for " + operation), (value.asBigInteger().compareTo(describedProperty.get("min").asBigInteger()) == -1 ? 1 : 0) != 0);
                    break;
                }
                case DOUBLE: {
                    Assert.assertFalse((String)(paramName + ":" + value.asDouble() + " is smaller than min " + describedProperty.get("min").asDouble() + " for " + operation), (value.asDouble() < describedProperty.get("min").asDouble() ? 1 : 0) != 0);
                    break;
                }
                case INT: {
                    Assert.assertFalse((String)(paramName + ":" + value.asInt() + " is smaller than min " + describedProperty.get("min").asInt() + " for " + operation), (value.asInt() < describedProperty.get("min").asInt() ? 1 : 0) != 0);
                    break;
                }
                case LONG: {
                    Assert.assertFalse((String)(paramName + ":" + value.asLong() + " is smaller than min " + describedProperty.get("min").asLong() + " for " + operation), (value.asLong() < describedProperty.get("min").asLong() ? 1 : 0) != 0);
                }
            }
        }
        if (describedProperty.hasDefined("max")) {
            switch (modelType) {
                case BIG_DECIMAL: {
                    Assert.assertFalse((String)(paramName + ":" + value.asBigDecimal() + " is bigger than max " + describedProperty.get("max").asBigDecimal() + " for " + operation), (value.asBigDecimal().compareTo(describedProperty.get("max").asBigDecimal()) == 1 ? 1 : 0) != 0);
                    break;
                }
                case BIG_INTEGER: {
                    Assert.assertFalse((String)(paramName + ":" + value.asBigInteger() + " is bigger than max " + describedProperty.get("max").asBigInteger() + " for " + operation), (value.asBigInteger().compareTo(describedProperty.get("max").asBigInteger()) == 1 ? 1 : 0) != 0);
                    break;
                }
                case DOUBLE: {
                    Assert.assertFalse((String)(paramName + ":" + value.asDouble() + " is bigger than max " + describedProperty.get("max").asDouble() + " for " + operation), (value.asDouble() > describedProperty.get("max").asDouble() ? 1 : 0) != 0);
                    break;
                }
                case INT: {
                    Assert.assertFalse((String)(paramName + ":" + value.asInt() + " is bigger than max " + describedProperty.get("max").asInt() + " for " + operation), (value.asInt() > describedProperty.get("max").asInt() ? 1 : 0) != 0);
                    break;
                }
                case LONG: {
                    Assert.assertFalse((String)(paramName + ":" + value.asLong() + " is bigger than max " + describedProperty.get("max").asLong() + " for " + operation), (value.asLong() > describedProperty.get("max").asLong() ? 1 : 0) != 0);
                }
            }
        }
        if (describedProperty.hasDefined("min-length")) {
            minLength = describedProperty.get("min-length").asInt();
            switch (modelType) {
                case LIST: {
                    Assert.assertTrue((String)(paramName + ":" + value.asList().size() + " is shorter than min-length " + minLength + " for " + operation), (value.asList().size() >= minLength ? 1 : 0) != 0);
                    break;
                }
                case BYTES: {
                    Assert.assertTrue((String)(paramName + ":" + value.asBytes().length + " is shorter than min-length " + minLength + " for " + operation), (value.asBytes().length >= minLength ? 1 : 0) != 0);
                    break;
                }
                case STRING: {
                    Assert.assertTrue((String)(paramName + ":" + value.asString().length() + " is shorter than min-length " + minLength + " for " + operation), (value.asString().length() >= minLength ? 1 : 0) != 0);
                }
            }
        }
        if (describedProperty.hasDefined("max-length")) {
            minLength = describedProperty.get("max-length").asInt();
            switch (modelType) {
                case LIST: {
                    Assert.assertTrue((String)(paramName + ":" + value.asList().size() + " is longer than max-length " + minLength + " for " + operation), (value.asList().size() <= minLength ? 1 : 0) != 0);
                    break;
                }
                case BYTES: {
                    Assert.assertTrue((String)(paramName + ":" + value.asBytes().length + " is longer than max-length " + minLength + " for " + operation), (value.asBytes().length <= minLength ? 1 : 0) != 0);
                    break;
                }
                case STRING: {
                    Assert.assertTrue((String)(paramName + ":" + value.asString().length() + " is longer than max-length " + minLength + " for " + operation), (value.asString().length() <= minLength ? 1 : 0) != 0);
                }
            }
        }
    }

    private void checkType(ModelType modelType, ModelNode value) {
        switch (modelType) {
            case BIG_DECIMAL: {
                value.asBigDecimal();
                break;
            }
            case BIG_INTEGER: {
                value.asBigInteger();
                break;
            }
            case BOOLEAN: {
                value.asBoolean();
                break;
            }
            case BYTES: {
                value.asBytes();
                break;
            }
            case DOUBLE: {
                value.asDouble();
                break;
            }
            case EXPRESSION: {
                value.asString();
                break;
            }
            case INT: {
                value.asInt();
                break;
            }
            case LIST: {
                value.asList();
                break;
            }
            case LONG: {
                value.asLong();
                break;
            }
            case OBJECT: {
                value.asObject();
                break;
            }
            case PROPERTY: {
                value.asProperty();
                break;
            }
            case STRING: {
                value.asString();
                break;
            }
            case TYPE: {
                value.asType();
            }
        }
    }

    private void checkList(ModelNode operation, String paramName, ModelType modelType, ModelNode describedProperty, ModelNode value) {
        if (describedProperty.get("type").asType() == ModelType.LIST && describedProperty.hasDefined("value-type") && describedProperty.get("value-type").getType() == ModelType.TYPE) {
            ModelType elementType = describedProperty.get("value-type").asType();
            for (ModelNode element : value.asList()) {
                try {
                    this.checkType(elementType, element);
                }
                catch (IllegalArgumentException e) {
                    Assert.fail((String)(paramName + " is expected to be a list of " + elementType + " " + operation));
                }
            }
        }
    }

    DescriptionProvider getDescriptionProvider(ModelNode operation) {
        Assert.assertTrue((String)"Operation has no operation field", (boolean)operation.hasDefined("operation"));
        Assert.assertTrue((String)"Operation has no address field", (boolean)operation.hasDefined("address"));
        String name = operation.get("operation").asString();
        Assert.assertNotNull((String)"Null operation name", (Object)name);
        Assert.assertTrue((String)("Empty operation name " + name), (name.trim().length() > 0 ? 1 : 0) != 0);
        PathAddress addr = PathAddress.pathAddress((ModelNode)operation.get("address"));
        DescriptionProvider provider = this.root.getOperationDescription(addr, name);
        Assert.assertNotNull((String)("No operation called '" + name + "' for " + addr), (Object)provider);
        return provider;
    }

    static boolean hasAlternative(Set<String> keys, Collection<ModelNode> alternatives) {
        if (alternatives == null || alternatives.isEmpty()) {
            return false;
        }
        for (ModelNode alternative : alternatives) {
            if (!keys.contains(alternative.asString())) continue;
            return true;
        }
        return false;
    }
}

