/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonProviders;
import org.jboss.as.controller.operations.common.InterfaceAddHandler;
import org.jboss.as.controller.operations.common.InterfaceCriteriaWriteHandler;
import org.jboss.as.controller.operations.common.SocketBindingGroupRemoveHandler;
import org.jboss.as.controller.operations.common.SystemPropertyAddHandler;
import org.jboss.as.controller.operations.common.SystemPropertyRemoveHandler;
import org.jboss.as.controller.operations.common.SystemPropertyValueWriteAttributeHandler;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.controller.descriptions.ServerDescriptionProviders;
import org.jboss.as.server.operations.SpecifiedPathAddHandler;
import org.jboss.as.server.operations.SpecifiedPathRemoveHandler;
import org.jboss.as.server.services.net.BindingAddHandler;
import org.jboss.as.server.services.net.BindingFixedPortHandler;
import org.jboss.as.server.services.net.BindingGroupAddHandler;
import org.jboss.as.server.services.net.BindingGroupDefaultInterfaceHandler;
import org.jboss.as.server.services.net.BindingGroupPortOffsetHandler;
import org.jboss.as.server.services.net.BindingInterfaceHandler;
import org.jboss.as.server.services.net.BindingMetricHandlers;
import org.jboss.as.server.services.net.BindingMulticastAddressHandler;
import org.jboss.as.server.services.net.BindingMulticastPortHandler;
import org.jboss.as.server.services.net.BindingPortHandler;
import org.jboss.as.server.services.net.BindingRemoveHandler;
import org.jboss.as.server.services.net.SpecifiedInterfaceAddHandler;
import org.jboss.as.server.services.net.SpecifiedInterfaceRemoveHandler;
import org.jboss.dmr.ModelNode;

public class ControllerInitializer {
    public static final String INTERFACE_NAME = "test-interface";
    public static final String SOCKET_BINDING_GROUP_NAME = "test-socket-binding-group";
    protected volatile String bindAddress = "localhost";
    protected final Map<String, String> systemProperties = new HashMap<String, String>();
    protected final Map<String, Integer> socketBindings = new HashMap<String, Integer>();
    protected final Map<String, PathInfo> paths = new HashMap<String, PathInfo>();

    public void addSystemProperty(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Null key");
        }
        if (value == null) {
            throw new IllegalArgumentException("Null value");
        }
        this.systemProperties.put(key, value);
    }

    public void setBindAddress(String address) {
        if (address == null) {
            throw new IllegalArgumentException("Null address");
        }
        this.bindAddress = address;
    }

    public void addSocketBinding(String name, int port) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (port < 0) {
            throw new IllegalArgumentException("Null port");
        }
        this.socketBindings.put(name, port);
    }

    public void addPath(String name, String path, String relativeTo) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        PathInfo pathInfo = new PathInfo(name, path, relativeTo);
        this.paths.put(name, pathInfo);
    }

    protected void initializeModel(Resource rootResource, ManagementResourceRegistration rootRegistration) {
        this.initializeSystemPropertiesModel(rootResource, rootRegistration);
        this.initializeSocketBindingsModel(rootResource, rootRegistration);
        this.initializePathsModel(rootResource, rootRegistration);
    }

    protected List<ModelNode> initializeBootOperations() {
        ArrayList<ModelNode> ops = new ArrayList<ModelNode>();
        this.initializeSystemPropertiesOperations(ops);
        this.initializePathsOperations(ops);
        this.initializeSocketBindingsOperations(ops);
        return ops;
    }

    protected void initializeSystemPropertiesModel(Resource rootResource, ManagementResourceRegistration rootRegistration) {
        if (this.systemProperties.size() == 0) {
            return;
        }
        rootResource.getModel().get("system-property");
        ManagementResourceRegistration sysProps = rootRegistration.registerSubModel(PathElement.pathElement((String)"system-property"), ServerDescriptionProviders.SYSTEM_PROPERTIES_PROVIDER);
        sysProps.registerOperationHandler("add", (OperationStepHandler)SystemPropertyAddHandler.INSTANCE_WITHOUT_BOOTTIME, (DescriptionProvider)SystemPropertyAddHandler.INSTANCE_WITHOUT_BOOTTIME, false);
        sysProps.registerOperationHandler("remove", (OperationStepHandler)SystemPropertyRemoveHandler.INSTANCE, (DescriptionProvider)SystemPropertyRemoveHandler.INSTANCE, false);
        sysProps.registerReadWriteAttribute("value", null, (OperationStepHandler)SystemPropertyValueWriteAttributeHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
    }

    protected void initializeSocketBindingsModel(Resource rootResource, ManagementResourceRegistration rootRegistration) {
        if (this.socketBindings.size() == 0) {
            return;
        }
        rootResource.getModel().get("interface");
        rootResource.getModel().get("socket-binding-group");
        ManagementResourceRegistration interfaces = rootRegistration.registerSubModel(PathElement.pathElement((String)"interface"), CommonProviders.SPECIFIED_INTERFACE_PROVIDER);
        interfaces.registerOperationHandler("add", (OperationStepHandler)SpecifiedInterfaceAddHandler.INSTANCE, (DescriptionProvider)SpecifiedInterfaceAddHandler.INSTANCE, false);
        interfaces.registerOperationHandler("remove", (OperationStepHandler)SpecifiedInterfaceRemoveHandler.INSTANCE, (DescriptionProvider)SpecifiedInterfaceRemoveHandler.INSTANCE, false);
        interfaces.registerReadWriteAttribute("criteria", null, InterfaceCriteriaWriteHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration socketGroup = rootRegistration.registerSubModel(PathElement.pathElement((String)"socket-binding-group"), ServerDescriptionProviders.SOCKET_BINDING_GROUP_PROVIDER);
        socketGroup.registerOperationHandler("add", (OperationStepHandler)BindingGroupAddHandler.INSTANCE, (DescriptionProvider)BindingGroupAddHandler.INSTANCE, false);
        socketGroup.registerOperationHandler("remove", (OperationStepHandler)SocketBindingGroupRemoveHandler.INSTANCE, (DescriptionProvider)SocketBindingGroupRemoveHandler.INSTANCE, false);
        socketGroup.registerReadWriteAttribute("port-offset", null, (OperationStepHandler)BindingGroupPortOffsetHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        socketGroup.registerReadWriteAttribute("default-interface", null, (OperationStepHandler)BindingGroupDefaultInterfaceHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration socketBinding = socketGroup.registerSubModel(PathElement.pathElement((String)"socket-binding"), CommonProviders.SOCKET_BINDING_PROVIDER);
        socketBinding.registerOperationHandler("add", (OperationStepHandler)BindingAddHandler.INSTANCE, (DescriptionProvider)BindingAddHandler.INSTANCE, false);
        socketBinding.registerOperationHandler("remove", (OperationStepHandler)BindingRemoveHandler.INSTANCE, (DescriptionProvider)BindingRemoveHandler.INSTANCE, false);
        socketBinding.registerMetric("bound", BindingMetricHandlers.BoundHandler.INSTANCE);
        socketBinding.registerMetric("bound-address", BindingMetricHandlers.BoundAddressHandler.INSTANCE);
        socketBinding.registerMetric("bound-port", BindingMetricHandlers.BoundPortHandler.INSTANCE);
        socketBinding.registerReadWriteAttribute("interface", null, (OperationStepHandler)BindingInterfaceHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        socketBinding.registerReadWriteAttribute("port", null, (OperationStepHandler)BindingPortHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        socketBinding.registerReadWriteAttribute("fixed-port", null, (OperationStepHandler)BindingFixedPortHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        socketBinding.registerReadWriteAttribute("multicast-address", null, (OperationStepHandler)BindingMulticastAddressHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        socketBinding.registerReadWriteAttribute("multicast-port", null, (OperationStepHandler)BindingMulticastPortHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
    }

    protected void initializePathsModel(Resource rootResource, ManagementResourceRegistration rootRegistration) {
        if (this.paths.size() == 0) {
            return;
        }
        rootResource.getModel().get("path");
        ManagementResourceRegistration paths = rootRegistration.registerSubModel(PathElement.pathElement((String)"path"), CommonProviders.SPECIFIED_PATH_PROVIDER);
        paths.registerOperationHandler("add", (OperationStepHandler)SpecifiedPathAddHandler.INSTANCE, (DescriptionProvider)SpecifiedPathAddHandler.INSTANCE, false);
        paths.registerOperationHandler("remove", (OperationStepHandler)SpecifiedPathRemoveHandler.INSTANCE, (DescriptionProvider)SpecifiedPathRemoveHandler.INSTANCE, false);
    }

    protected void initializeSystemPropertiesOperations(List<ModelNode> ops) {
        for (Map.Entry<String, String> prop : this.systemProperties.entrySet()) {
            ModelNode op = new ModelNode();
            op.get("operation").set("add");
            op.get("address").set(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"system-property", (String)prop.getKey())}).toModelNode());
            op.get("value").set(prop.getValue());
            ops.add(op);
        }
    }

    protected void initializeSocketBindingsOperations(List<ModelNode> ops) {
        if (this.socketBindings.size() == 0) {
            return;
        }
        ModelNode criteria = new ModelNode();
        criteria.add("inet-address", this.bindAddress);
        ModelNode op = InterfaceAddHandler.getAddInterfaceOperation((ModelNode)PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"interface", (String)INTERFACE_NAME)}).toModelNode(), (ModelNode)criteria);
        ops.add(op);
        op = new ModelNode();
        op.get("operation").set("add");
        op.get("address").set(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"socket-binding-group", (String)SOCKET_BINDING_GROUP_NAME)}).toModelNode());
        op.get("default-interface").set(INTERFACE_NAME);
        ops.add(op);
        for (Map.Entry<String, Integer> binding : this.socketBindings.entrySet()) {
            op = new ModelNode();
            op.get("operation").set("add");
            op.get("address").set(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"socket-binding-group", (String)SOCKET_BINDING_GROUP_NAME), PathElement.pathElement((String)"socket-binding", (String)binding.getKey())}).toModelNode());
            op.get("port").set(binding.getValue().intValue());
            ops.add(op);
        }
    }

    protected void initializePathsOperations(List<ModelNode> ops) {
        if (this.paths.size() == 0) {
            return;
        }
        for (PathInfo path : this.paths.values()) {
            ModelNode op = new ModelNode();
            op.get("operation").set("add");
            op.get("address").set(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"path", (String)path.getName())}).toModelNode());
            op.get("path").set(path.getPath());
            if (path.getRelativeTo() != null) {
                op.get("relative-to").set(path.getRelativeTo());
            }
            ops.add(op);
        }
    }

    private static class PathInfo {
        private final String name;
        private final String path;
        private final String relativeTo;

        public PathInfo(String name, String path, String relativeTo) {
            this.name = name;
            this.path = path;
            this.relativeTo = relativeTo;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public String getRelativeTo() {
            return this.relativeTo;
        }
    }
}

