/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.vault;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.as.server.services.security.VaultReaderException;
import org.jboss.security.vault.SecurityVault;
import org.jboss.security.vault.SecurityVaultException;
import org.jboss.security.vault.SecurityVaultFactory;

public class RuntimeVaultReader
extends AbstractVaultReader {
    private static final Pattern VAULT_PATTERN = Pattern.compile("VAULT::.*::.*::.*");
    private volatile SecurityVault vault;

    protected void createVault(final String fqn, Map<String, Object> options) throws VaultReaderException {
        HashMap<String, Object> vaultOptions = new HashMap<String, Object>(options);
        SecurityVault vault = null;
        try {
            vault = AccessController.doPrivileged(new PrivilegedExceptionAction<SecurityVault>(){

                @Override
                public SecurityVault run() throws Exception {
                    if (fqn == null || fqn.isEmpty()) {
                        return SecurityVaultFactory.get();
                    }
                    return SecurityVaultFactory.get((String)fqn);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof SecurityVaultException) {
                throw new VaultReaderException(t);
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        try {
            vault.init(vaultOptions);
        }
        catch (SecurityVaultException e) {
            throw new VaultReaderException((Throwable)e);
        }
        this.vault = vault;
    }

    protected void destroyVault() {
        this.vault = null;
    }

    public String retrieveFromVault(String password) throws SecurityException {
        if (this.isVaultFormat(password)) {
            if (this.vault == null) {
                throw new SecurityException("Vault is not initialized");
            }
            try {
                return this.getValueAsString(password);
            }
            catch (SecurityVaultException e) {
                throw new SecurityException(e);
            }
        }
        return password;
    }

    private String getValueAsString(String vaultString) throws SecurityVaultException {
        char[] val = this.getValue(vaultString);
        if (val != null) {
            return new String(val);
        }
        return null;
    }

    public boolean isVaultFormat(String str) {
        return str != null && VAULT_PATTERN.matcher(str).matches();
    }

    private char[] getValue(String vaultString) throws SecurityVaultException {
        String[] tokens = this.tokens(vaultString);
        return this.vault.retrieve(tokens[1], tokens[2], tokens[3].getBytes());
    }

    private String[] tokens(String vaultString) {
        StringTokenizer tokenizer = new StringTokenizer(vaultString, "::");
        int length = tokenizer.countTokens();
        String[] tokens = new String[length];
        int index = 0;
        while (tokenizer != null && tokenizer.hasMoreTokens()) {
            tokens[index++] = tokenizer.nextToken();
        }
        return tokens;
    }
}

