/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.util.HashMap;
import java.util.Map;

enum Element {
    UNKNOWN(null),
    ACL("acl"),
    ACL_MODULE("acl-module"),
    ADDITIONAL_PROPERTIES("additional-properties"),
    AUDIT("audit"),
    AUTH_MODULE("auth-module"),
    AUTHENTICATION("authentication"),
    AUTHENTICATION_JASPI("authentication-jaspi"),
    AUTHORIZATION("authorization"),
    IDENTITY_TRUST("identity-trust"),
    JSSE("jsse"),
    LOGIN_MODULE("login-module"),
    LOGIN_MODULE_STACK("login-module-stack"),
    MAPPING("mapping"),
    MAPPING_MODULE("mapping-module"),
    MODULE_OPTION("module-option"),
    POLICY_MODULE("policy-module"),
    PROVIDER_MODULE("provider-module"),
    PROPERTY("property"),
    SECURITY_DOMAIN("security-domain"),
    SECURITY_DOMAINS("security-domains"),
    SECURITY_MANAGEMENT("security-management"),
    SECURITY_PROPERTIES("security-properties"),
    SUBJECT_FACTORY("subject-factory"),
    TRUST_MODULE("trust-module");

    private final String name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

