/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.plugins;

import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.audit.AuditManager;
import org.jboss.security.identitytrust.IdentityTrustManager;
import org.jboss.security.mapping.MappingManager;

public class SecurityDomainContext {
    static final String ACTIVE_SUBJECT = "subject";
    static final String AUTHENTICATION_MGR = "authenticationMgr";
    static final String REALM_MAPPING = "realmMapping";
    static final String AUTHORIZATION_MGR = "authorizationMgr";
    static final String AUDIT_MGR = "auditMgr";
    static final String MAPPING_MGR = "mappingMgr";
    static final String IDENTITY_TRUST_MGR = "identityTrustMgr";
    static final String AUTH_CACHE = "authenticationCache";
    static final String DOMAIN_CONTEXT = "domainContext";
    AuthenticationManager authenticationMgr;
    AuthorizationManager authorizationMgr;
    AuditManager auditMgr;
    MappingManager mappingMgr;
    IdentityTrustManager identityTrustMgr;
    Object authenticationCache;
    private static final String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";

    public SecurityDomainContext(AuthenticationManager authenticationMgr, Object authenticationCache) {
        this.authenticationMgr = authenticationMgr;
        this.authenticationCache = authenticationCache;
    }

    public Object lookup(String name) throws NamingException {
        Object binding = null;
        if (name == null || name.length() == 0) {
            throw new InvalidNameException("name cannot be null or empty");
        }
        if (name.equals(ACTIVE_SUBJECT)) {
            binding = this.getSubject();
        } else if (name.equals(AUTHENTICATION_MGR)) {
            binding = this.getAuthenticationManager();
        } else if (name.equals(REALM_MAPPING)) {
            binding = this.getRealmMapping();
        } else if (name.equals(AUTHORIZATION_MGR)) {
            binding = this.getAuthorizationManager();
        } else if (name.equals(AUDIT_MGR)) {
            binding = this.getAuditMgr();
        } else if (name.equals(MAPPING_MGR)) {
            binding = this.getMappingMgr();
        } else if (name.equals(IDENTITY_TRUST_MGR)) {
            binding = this.getIdentityTrustMgr();
        } else if (name.equals(AUTH_CACHE)) {
            binding = this.authenticationCache;
        } else if (name.equals(DOMAIN_CONTEXT)) {
            binding = this;
        }
        return binding;
    }

    public Subject getSubject() {
        Subject subject = null;
        try {
            subject = (Subject)PolicyContext.getContext((String)SUBJECT_CONTEXT_KEY);
        }
        catch (PolicyContextException policyContextException) {
            // empty catch block
        }
        return subject;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationMgr;
    }

    public RealmMapping getRealmMapping() {
        RealmMapping realmMapping = null;
        if (this.authorizationMgr != null && this.authorizationMgr instanceof RealmMapping) {
            realmMapping = (RealmMapping)this.authorizationMgr;
        } else if (this.authenticationMgr instanceof RealmMapping) {
            realmMapping = (RealmMapping)this.authenticationMgr;
        }
        return realmMapping;
    }

    public void setAuthenticationManager(AuthenticationManager am) {
        this.authenticationMgr = am;
    }

    public void setAuthorizationManager(AuthorizationManager am) {
        this.authorizationMgr = am;
    }

    public AuthorizationManager getAuthorizationManager() {
        return this.authorizationMgr;
    }

    public void setAuthenticationCache(Object cp) {
        this.authenticationCache = cp;
    }

    public Object getAuthenticationCache() {
        return this.authenticationCache;
    }

    public AuditManager getAuditMgr() {
        return this.auditMgr;
    }

    public void setAuditMgr(AuditManager auditMgr) {
        this.auditMgr = auditMgr;
    }

    public MappingManager getMappingMgr() {
        return this.mappingMgr;
    }

    public void setMappingMgr(MappingManager mappingMgr) {
        this.mappingMgr = mappingMgr;
    }

    public IdentityTrustManager getIdentityTrustMgr() {
        return this.identityTrustMgr;
    }

    public void setIdentityTrustMgr(IdentityTrustManager identityTrustMgr) {
        this.identityTrustMgr = identityTrustMgr;
    }
}

