/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.security.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class SecuritySubsystemDescriptions {
    static final String RESOURCE_NAME = SecuritySubsystemDescriptions.class.getPackage().getName() + ".LocalDescriptions";
    static final DescriptionProvider SUBSYSTEM = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSubsystem(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSubsystemAdd(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_DESCRIBE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    };
    static final DescriptionProvider SECURITY_DOMAIN = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSecurityDomain(locale);
        }
    };
    static final DescriptionProvider SECURITY_DOMAIN_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            return subsystem;
        }
    };
    static final DescriptionProvider SECURITY_DOMAIN_REMOVE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            return subsystem;
        }
    };

    SecuritySubsystemDescriptions() {
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }

    private static class Descriptions {
        private Descriptions() {
        }

        static ModelNode getSubsystem(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            subsystem.get("description").set(bundle.getString("security"));
            subsystem.get("head-comment-allowed").set(true);
            subsystem.get("tail-comment-allowed").set(true);
            subsystem.get("namespace").set(Namespace.SECURITY_1_0.getUriString());
            subsystem.get(new String[]{"attributes", "authentication-manager-class-name", "description"}).set(bundle.getString("authentication-manager"));
            subsystem.get(new String[]{"attributes", "authentication-manager-class-name", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "authentication-manager-class-name", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "authentication-manager-class-name", "default"}).set("default");
            subsystem.get(new String[]{"attributes", "deep-copy-subject-mode", "description"}).set(bundle.getString("deep-copy-subject-mode"));
            subsystem.get(new String[]{"attributes", "deep-copy-subject-mode", "type"}).set(ModelType.BOOLEAN);
            subsystem.get(new String[]{"attributes", "deep-copy-subject-mode", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "deep-copy-subject-mode", "default"}).set(false);
            subsystem.get(new String[]{"attributes", "default-callback-handler-class-name", "description"}).set(bundle.getString("default-callback-handler-class-name"));
            subsystem.get(new String[]{"attributes", "default-callback-handler-class-name", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "default-callback-handler-class-name", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "default-callback-handler-class-name", "default"}).set("default");
            subsystem.get(new String[]{"attributes", "subject-factory-class-name", "description"}).set(bundle.getString("subject-factory-class-name"));
            subsystem.get(new String[]{"attributes", "default-callback-handler-class-name", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "default-callback-handler-class-name", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "default-callback-handler-class-name", "default"}).set("default");
            subsystem.get(new String[]{"attributes", "authorization-manager-class-name", "description"}).set(bundle.getString("authorization-manager-class-name"));
            subsystem.get(new String[]{"attributes", "authorization-manager-class-name", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "authorization-manager-class-name", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "authorization-manager-class-name", "default"}).set("default");
            subsystem.get(new String[]{"attributes", "audit-manager-class-name", "description"}).set(bundle.getString("audit-manager-class-name"));
            subsystem.get(new String[]{"attributes", "audit-manager-class-name", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "audit-manager-class-name", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "audit-manager-class-name", "default"}).set("default");
            subsystem.get(new String[]{"attributes", "identity-trust-manager-class-name", "description"}).set(bundle.getString("identity-trust-manager-class-name"));
            subsystem.get(new String[]{"attributes", "identity-trust-manager-class-name", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "identity-trust-manager-class-name", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "identity-trust-manager-class-name", "default"}).set("default");
            subsystem.get(new String[]{"attributes", "mapping-manager-class-name", "description"}).set(bundle.getString("mapping-manager-class-name"));
            subsystem.get(new String[]{"attributes", "identity-trust-manager-class-name", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "identity-trust-manager-class-name", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "identity-trust-manager-class-name", "default"}).set("default");
            subsystem.get(new String[]{"children", "security-domain", "description"}).set(bundle.getString("security-domain-children"));
            subsystem.get(new String[]{"children", "security-domain", "required"}).set(false);
            subsystem.get(new String[]{"children", "security-domain", "min-occurs"}).set(0);
            subsystem.get(new String[]{"children", "security-domain", "max-occurs"}).set(Integer.MAX_VALUE);
            subsystem.get(new String[]{"children", "security-domain", "model-description"}).setEmptyObject();
            return subsystem;
        }

        static ModelNode getSubsystemAdd(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("add");
            op.get("description").set(bundle.getString("security.add"));
            op.get(new String[]{"request-properties", "authentication-manager-class-name", "description"}).set(bundle.getString("authentication-manager"));
            op.get(new String[]{"request-properties", "authentication-manager-class-name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "authentication-manager-class-name", "required"}).set(false);
            op.get(new String[]{"request-properties", "authentication-manager-class-name", "default"}).set("default");
            op.get(new String[]{"request-properties", "deep-copy-subject-mode", "description"}).set(bundle.getString("deep-copy-subject-mode"));
            op.get(new String[]{"request-properties", "deep-copy-subject-mode", "type"}).set(ModelType.BOOLEAN);
            op.get(new String[]{"request-properties", "deep-copy-subject-mode", "required"}).set(false);
            op.get(new String[]{"request-properties", "deep-copy-subject-mode", "default"}).set(false);
            op.get(new String[]{"request-properties", "default-callback-handler-class-name", "description"}).set(bundle.getString("default-callback-handler-class-name"));
            op.get(new String[]{"request-properties", "default-callback-handler-class-name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "default-callback-handler-class-name", "required"}).set(false);
            op.get(new String[]{"request-properties", "default-callback-handler-class-name", "default"}).set("default");
            op.get(new String[]{"request-properties", "subject-factory-class-name", "description"}).set(bundle.getString("subject-factory-class-name"));
            op.get(new String[]{"request-properties", "default-callback-handler-class-name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "default-callback-handler-class-name", "required"}).set(false);
            op.get(new String[]{"request-properties", "default-callback-handler-class-name", "default"}).set("default");
            op.get(new String[]{"request-properties", "authorization-manager-class-name", "description"}).set(bundle.getString("authorization-manager-class-name"));
            op.get(new String[]{"request-properties", "authorization-manager-class-name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "authorization-manager-class-name", "required"}).set(false);
            op.get(new String[]{"request-properties", "authorization-manager-class-name", "default"}).set("default");
            op.get(new String[]{"request-properties", "audit-manager-class-name", "description"}).set(bundle.getString("audit-manager-class-name"));
            op.get(new String[]{"request-properties", "audit-manager-class-name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "audit-manager-class-name", "required"}).set(false);
            op.get(new String[]{"request-properties", "audit-manager-class-name", "default"}).set("default");
            op.get(new String[]{"request-properties", "identity-trust-manager-class-name", "description"}).set(bundle.getString("identity-trust-manager-class-name"));
            op.get(new String[]{"request-properties", "identity-trust-manager-class-name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "identity-trust-manager-class-name", "required"}).set(false);
            op.get(new String[]{"request-properties", "identity-trust-manager-class-name", "default"}).set("default");
            op.get(new String[]{"request-properties", "mapping-manager-class-name", "description"}).set(bundle.getString("mapping-manager-class-name"));
            op.get(new String[]{"request-properties", "identity-trust-manager-class-name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "identity-trust-manager-class-name", "required"}).set(false);
            op.get(new String[]{"request-properties", "identity-trust-manager-class-name", "default"}).set("default");
            op.get("reply-properties").setEmptyObject();
            return op;
        }

        static ModelNode getSecurityDomain(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("description").set(bundle.getString("security-domain"));
            op.get("head-comment-allowed").set(true);
            op.get("tail-comment-allowed").set(true);
            return op;
        }
    }
}

