/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.security.Attribute;
import org.jboss.as.security.Element;
import org.jboss.as.security.ModulesMap;
import org.jboss.as.security.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class SecuritySubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext>,
ModulesMap {
    SecuritySubsystemParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        ModelNode address = subsystem.get("address");
        address.add("subsystem", "security");
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        List<ModelNode> jaasUpdates = null;
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case SECURITY_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    if (!visited.add(element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    switch (element) {
                        case SECURITY_MANAGEMENT: {
                            this.parseSecurityManagement(reader, subsystem);
                            continue block8;
                        }
                        case SUBJECT_FACTORY: {
                            this.parseSubjectFactory(reader, subsystem);
                            continue block8;
                        }
                        case JAAS: {
                            jaasUpdates = this.parseJaas(reader, address);
                            continue block8;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.add(subsystem);
        if (jaasUpdates != null) {
            list.addAll(jaasUpdates);
        }
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        if (this.isNonStandard(node, "authentication-manager-class-name") || node.hasDefined("deep-copy-subject-mode") && node.get("deep-copy-subject-mode").asBoolean() || this.isNonStandard(node, "default-callback-handler-class-name") || this.isNonStandard(node, "authorization-manager-class-name") || this.isNonStandard(node, "audit-manager-class-name") || this.isNonStandard(node, "identity-trust-manager-class-name") || this.isNonStandard(node, "mapping-manager-class-name")) {
            writer.writeEmptyElement(Element.SECURITY_MANAGEMENT.getLocalName());
            if (this.isNonStandard(node, "authentication-manager-class-name")) {
                this.writeAttribute(writer, Attribute.AUTHENTICATION_MANAGER_CLASS_NAME, node.get("authentication-manager-class-name"));
            }
            if (node.hasDefined("deep-copy-subject-mode") && node.get("deep-copy-subject-mode").asBoolean()) {
                this.writeAttribute(writer, Attribute.DEEP_COPY_SUBJECT_MODE, node.get("deep-copy-subject-mode"));
            }
            if (this.isNonStandard(node, "default-callback-handler-class-name")) {
                this.writeAttribute(writer, Attribute.DEFAULT_CALLBACK_HANDLER_CLASS_NAME, node.get("default-callback-handler-class-name"));
            }
            if (this.isNonStandard(node, "authorization-manager-class-name")) {
                this.writeAttribute(writer, Attribute.AUTHORIZATION_MANAGER_CLASS_NAME, node.get("authorization-manager-class-name"));
            }
            if (this.isNonStandard(node, "audit-manager-class-name")) {
                this.writeAttribute(writer, Attribute.AUDIT_MANAGER_CLASS_NAME, node.get("audit-manager-class-name"));
            }
            if (this.isNonStandard(node, "identity-trust-manager-class-name")) {
                this.writeAttribute(writer, Attribute.IDENTITY_TRUST_MANAGER_CLASS_NAME, node.get("identity-trust-manager-class-name"));
            }
            if (this.isNonStandard(node, "mapping-manager-class-name")) {
                this.writeAttribute(writer, Attribute.MAPPING_MANAGER_CLASS_NAME, node.get("mapping-manager-class-name"));
            }
        }
        if (this.isNonStandard(node, "subject-factory-class-name")) {
            writer.writeEmptyElement(Element.SUBJECT_FACTORY.getLocalName());
            this.writeAttribute(writer, Attribute.SUBJECT_FACTORY_CLASS_NAME, node.get("subject-factory-class-name"));
        }
        if (node.hasDefined("security-domain") && node.get("security-domain").asInt() > 0) {
            writer.writeStartElement(Element.JAAS.getLocalName());
            for (Property policy : node.get("security-domain").asPropertyList()) {
                writer.writeStartElement(Element.SECURITY_DOMAIN.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), policy.getName());
                ModelNode policyDetails = policy.getValue();
                if (policyDetails.hasDefined(Attribute.EXTENDS.getLocalName())) {
                    writer.writeAttribute(Attribute.EXTENDS.getLocalName(), policyDetails.get(Attribute.EXTENDS.getLocalName()).asString());
                }
                this.writeSecurityDomainContent(writer, policyDetails);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeSecurityDomainContent(XMLExtendedStreamWriter writer, ModelNode policyDetails) throws XMLStreamException {
        HashSet keys = new HashSet(policyDetails.keys());
        keys.remove(Attribute.NAME.getLocalName());
        keys.remove(Attribute.EXTENDS.getLocalName());
        block9: for (String key : keys) {
            Element element = Element.forName(key);
            switch (element) {
                case AUTHENTICATION: {
                    this.writeAuthentication(writer, policyDetails.get(Element.AUTHENTICATION.getLocalName()));
                    continue block9;
                }
                case AUTHORIZATION: {
                    this.writeAuthorization(writer, policyDetails.get(Element.AUTHORIZATION.getLocalName()));
                    continue block9;
                }
                case ACL: {
                    this.writeACL(writer, policyDetails.get(Element.ACL.getLocalName()));
                    continue block9;
                }
                case AUDIT: {
                    this.writeAudit(writer, policyDetails.get(Element.AUDIT.getLocalName()));
                    continue block9;
                }
                case IDENTITY_TRUST: {
                    this.writeIdentityTrust(writer, policyDetails.get(Element.IDENTITY_TRUST.getLocalName()));
                    continue block9;
                }
                case MAPPING: {
                    this.writeMapping(writer, policyDetails.get(Element.MAPPING.getLocalName()));
                    continue block9;
                }
                case AUTHENTICATION_JASPI: {
                    this.writeAuthenticationJaspi(writer, policyDetails.get(Element.AUTHENTICATION_JASPI.getLocalName()));
                    continue block9;
                }
            }
            throw new IllegalStateException("Unexpected field " + element.getLocalName());
        }
    }

    private void writeAuthentication(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.AUTHENTICATION.getLocalName());
            for (ModelNode loginModule : modelNode.asList()) {
                writer.writeStartElement(Element.LOGIN_MODULE.getLocalName());
                this.writeCommonModule(writer, loginModule, Element.AUTHENTICATION);
            }
            writer.writeEndElement();
        }
    }

    private void writeAuthorization(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.AUTHORIZATION.getLocalName());
            for (ModelNode loginModule : modelNode.asList()) {
                writer.writeStartElement(Element.POLICY_MODULE.getLocalName());
                this.writeCommonModule(writer, loginModule, Element.AUTHORIZATION);
            }
            writer.writeEndElement();
        }
    }

    private void writeACL(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.ACL.getLocalName());
            for (ModelNode loginModule : modelNode.asList()) {
                writer.writeStartElement(Element.ACL_MODULE.getLocalName());
                this.writeCommonModule(writer, loginModule, Element.ACL);
            }
            writer.writeEndElement();
        }
    }

    private void writeAudit(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.AUDIT.getLocalName());
            for (ModelNode loginModule : modelNode.asList()) {
                writer.writeStartElement(Element.PROVIDER_MODULE.getLocalName());
                this.writeCommonModule(writer, loginModule, Element.AUDIT);
            }
            writer.writeEndElement();
        }
    }

    private void writeIdentityTrust(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.IDENTITY_TRUST.getLocalName());
            for (ModelNode loginModule : modelNode.asList()) {
                writer.writeStartElement(Element.TRUST_MODULE.getLocalName());
                this.writeCommonModule(writer, loginModule, Element.IDENTITY_TRUST);
            }
            writer.writeEndElement();
        }
    }

    private void writeMapping(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.MAPPING.getLocalName());
            for (ModelNode loginModule : modelNode.asList()) {
                writer.writeStartElement(Element.MAPPING_MODULE.getLocalName());
                this.writeCommonModule(writer, loginModule, Element.MAPPING);
            }
            writer.writeEndElement();
        }
    }

    private void writeAuthenticationJaspi(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.AUTHENTICATION_JASPI.getLocalName());
            ModelNode moduleStack = modelNode.get(Element.LOGIN_MODULE_STACK.getLocalName());
            this.writeLoginModuleStack(writer, moduleStack);
            ModelNode authModule = modelNode.get(Element.AUTH_MODULE.getLocalName());
            this.writeAuthModule(writer, authModule);
            writer.writeEndElement();
        }
    }

    private void writeLoginModuleStack(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.LOGIN_MODULE_STACK.getLocalName());
            List modules = modelNode.asList();
            Iterator iter = modules.iterator();
            ModelNode nameNode = (ModelNode)iter.next();
            writer.writeAttribute(Attribute.NAME.getLocalName(), nameNode.require(Attribute.NAME.getLocalName()).asString());
            while (iter.hasNext()) {
                ModelNode loginModule = (ModelNode)iter.next();
                writer.writeStartElement(Element.LOGIN_MODULE.getLocalName());
                this.writeCommonModule(writer, loginModule, Element.AUTHENTICATION);
            }
            writer.writeEndElement();
        }
    }

    private void writeAuthModule(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.AUTH_MODULE.getLocalName());
            this.writeCommonModule(writer, modelNode, Element.AUTH_MODULE);
        }
    }

    private void writeCommonModule(XMLExtendedStreamWriter writer, ModelNode module, Element type) throws XMLStreamException {
        String code = module.require(Attribute.CODE.getLocalName()).asString();
        code = this.getCode(code, type);
        writer.writeAttribute(Attribute.CODE.getLocalName(), code);
        if (module.hasDefined(Attribute.FLAG.getLocalName())) {
            writer.writeAttribute(Attribute.FLAG.getLocalName(), module.get(Attribute.FLAG.getLocalName()).asString());
        }
        if (module.hasDefined(Attribute.TYPE.getLocalName())) {
            writer.writeAttribute(Attribute.TYPE.getLocalName(), module.get(Attribute.TYPE.getLocalName()).asString());
        }
        if (module.hasDefined(Attribute.LOGIN_MODULE_STACK_REF.getLocalName())) {
            writer.writeAttribute(Attribute.LOGIN_MODULE_STACK_REF.getLocalName(), module.get(Attribute.LOGIN_MODULE_STACK_REF.getLocalName()).asString());
        }
        if (module.hasDefined("module-options") && module.get("module-options").asInt() > 0) {
            this.writeModuleOptions(writer, module.get("module-options"));
        }
        writer.writeEndElement();
    }

    private void writeModuleOptions(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        for (Property prop : modelNode.asPropertyList()) {
            writer.writeEmptyElement(Element.MODULE_OPTION.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), prop.getName());
            writer.writeAttribute(Attribute.VALUE.getLocalName(), prop.getValue().asString());
        }
    }

    private boolean isNonStandard(ModelNode node, String attribute) {
        return node.hasDefined(attribute) && !"default".equals(node.get(attribute).asString());
    }

    private void writeAttribute(XMLExtendedStreamWriter writer, Attribute attr, ModelNode value) throws XMLStreamException {
        writer.writeAttribute(attr.getLocalName(), value.asString());
    }

    private void parseSecurityManagement(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        String authenticationManagerClassName = null;
        boolean deepCopySubjectMode = false;
        String defaultCallbackHandlerClassName = null;
        String authorizationManagerClassName = null;
        String auditManagerClassName = null;
        String identityTrustManagerClassName = null;
        String mappingManagerClassName = null;
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case AUTHENTICATION_MANAGER_CLASS_NAME: {
                    authenticationManagerClassName = value;
                    continue block9;
                }
                case DEEP_COPY_SUBJECT_MODE: {
                    deepCopySubjectMode = Boolean.parseBoolean(value);
                    continue block9;
                }
                case DEFAULT_CALLBACK_HANDLER_CLASS_NAME: {
                    defaultCallbackHandlerClassName = value;
                    continue block9;
                }
                case AUTHORIZATION_MANAGER_CLASS_NAME: {
                    authorizationManagerClassName = value;
                    continue block9;
                }
                case AUDIT_MANAGER_CLASS_NAME: {
                    auditManagerClassName = value;
                    continue block9;
                }
                case IDENTITY_TRUST_MANAGER_CLASS_NAME: {
                    identityTrustManagerClassName = value;
                    continue block9;
                }
                case MAPPING_MANAGER_CLASS_NAME: {
                    mappingManagerClassName = value;
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (authenticationManagerClassName != null) {
            operation.get("authentication-manager-class-name").set(authenticationManagerClassName);
        }
        if (defaultCallbackHandlerClassName != null) {
            operation.get("default-callback-handler-class-name").set(defaultCallbackHandlerClassName);
        }
        if (deepCopySubjectMode) {
            operation.get("deep-copy-subject-mode").set(deepCopySubjectMode);
        }
        if (authorizationManagerClassName != null) {
            operation.get("authorization-manager-class-name").set(authorizationManagerClassName);
        }
        if (auditManagerClassName != null) {
            operation.get("audit-manager-class-name").set(auditManagerClassName);
        }
        if (identityTrustManagerClassName != null) {
            operation.get("identity-trust-manager-class-name").set(identityTrustManagerClassName);
        }
        if (mappingManagerClassName != null) {
            operation.get("mapping-manager-class-name").set(mappingManagerClassName);
        }
    }

    private void parseSubjectFactory(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        String subjectFactoryClassName = null;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SUBJECT_FACTORY_CLASS_NAME: {
                    subjectFactoryClassName = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (subjectFactoryClassName != null) {
            operation.get("subject-factory-class-name").set(subjectFactoryClassName);
        }
    }

    private List<ModelNode> parseJaas(XMLExtendedStreamReader reader, ModelNode parentAddress) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case SECURITY_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case SECURITY_DOMAIN: {
                            list.add(this.parseSecurityDomain(reader, parentAddress));
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return list;
    }

    private ModelNode parseSecurityDomain(XMLExtendedStreamReader reader, ModelNode parentAddress) throws XMLStreamException {
        ModelNode op = new ModelNode();
        op.get("operation").set("add");
        ModelNode address = op.get("address");
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block16: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    address.set(parentAddress).add("security-domain", value);
                    continue block16;
                }
                case EXTENDS: {
                    op.get(attribute.getLocalName()).set(value);
                    continue block16;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block17: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case SECURITY_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    if (!visited.add(element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    switch (element) {
                        case AUTHENTICATION: {
                            if (visited.contains((Object)Element.AUTHENTICATION_JASPI)) {
                                throw new XMLStreamException("A security domain can have either an <authentication> or <authentication-jaspi> element, not both", reader.getLocation());
                            }
                            this.parseAuthentication(reader, op.get(Element.AUTHENTICATION.getLocalName()), true);
                            continue block17;
                        }
                        case AUTHORIZATION: {
                            this.parseAuthorization(reader, op.get(Element.AUTHORIZATION.getLocalName()));
                            continue block17;
                        }
                        case ACL: {
                            this.parseACL(reader, op.get(Element.ACL.getLocalName()));
                            continue block17;
                        }
                        case AUDIT: {
                            this.parseAudit(reader, op.get(Element.AUDIT.getLocalName()));
                            continue block17;
                        }
                        case IDENTITY_TRUST: {
                            this.parseIdentityTrust(reader, op.get(Element.IDENTITY_TRUST.getLocalName()));
                            continue block17;
                        }
                        case MAPPING: {
                            this.parseMapping(reader, op.get(Element.MAPPING.getLocalName()));
                            continue block17;
                        }
                        case AUTHENTICATION_JASPI: {
                            if (visited.contains((Object)Element.AUTHENTICATION)) {
                                throw new XMLStreamException("A security domain can have either an <authentication> or <authentication-jaspi> element, not both", reader.getLocation());
                            }
                            this.parseAuthenticationJaspi(reader, op.get(Element.AUTHENTICATION_JASPI.getLocalName()));
                            continue block17;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return op;
    }

    private void parseAuthentication(XMLExtendedStreamReader reader, ModelNode op, boolean requireNoAttributes) throws XMLStreamException {
        if (requireNoAttributes) {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        }
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case SECURITY_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case LOGIN_MODULE: {
                            EnumSet<Attribute> required = EnumSet.of(Attribute.CODE, Attribute.FLAG);
                            EnumSet<Attribute> notAllowed = EnumSet.of(Attribute.TYPE);
                            this.parseCommonModule(reader, op.add(), required, notAllowed, Element.AUTHENTICATION);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseAuthorization(XMLExtendedStreamReader reader, ModelNode op) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case SECURITY_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case POLICY_MODULE: {
                            EnumSet<Attribute> required = EnumSet.of(Attribute.CODE, Attribute.FLAG);
                            EnumSet<Attribute> notAllowed = EnumSet.of(Attribute.TYPE);
                            this.parseCommonModule(reader, op.add(), required, notAllowed, Element.AUTHORIZATION);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseACL(XMLExtendedStreamReader reader, ModelNode op) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case SECURITY_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case ACL_MODULE: {
                            EnumSet<Attribute> required = EnumSet.of(Attribute.CODE, Attribute.FLAG);
                            EnumSet<Attribute> notAllowed = EnumSet.of(Attribute.TYPE);
                            this.parseCommonModule(reader, op.add(), required, notAllowed, Element.ACL);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseAudit(XMLExtendedStreamReader reader, ModelNode op) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case SECURITY_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case PROVIDER_MODULE: {
                            EnumSet<Attribute> required = EnumSet.of(Attribute.CODE);
                            EnumSet<Attribute> notAllowed = EnumSet.of(Attribute.TYPE, Attribute.FLAG);
                            this.parseCommonModule(reader, op.add(), required, notAllowed, Element.AUDIT);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseIdentityTrust(XMLExtendedStreamReader reader, ModelNode op) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case SECURITY_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case TRUST_MODULE: {
                            EnumSet<Attribute> required = EnumSet.of(Attribute.CODE, Attribute.FLAG);
                            EnumSet<Attribute> notAllowed = EnumSet.of(Attribute.TYPE);
                            this.parseCommonModule(reader, op.add(), required, notAllowed, Element.IDENTITY_TRUST);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseMapping(XMLExtendedStreamReader reader, ModelNode op) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case SECURITY_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case MAPPING_MODULE: {
                            EnumSet<Attribute> required = EnumSet.of(Attribute.CODE);
                            EnumSet<Attribute> notAllowed = EnumSet.of(Attribute.FLAG);
                            this.parseCommonModule(reader, op.add(), required, notAllowed, Element.MAPPING);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseCommonModule(XMLExtendedStreamReader reader, ModelNode node, EnumSet<Attribute> required, EnumSet<Attribute> notAllowed, Element type) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            if (notAllowed.contains((Object)attribute)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            required.remove((Object)attribute);
            switch (attribute) {
                case CODE: {
                    String code = null;
                    switch (type) {
                        case AUTHENTICATION: {
                            code = (String)AUTHENTICATION_MAP.get(value);
                            break;
                        }
                    }
                    if (code == null) {
                        code = value;
                    }
                    node.get(Attribute.CODE.getLocalName()).set(code);
                    continue block14;
                }
                case FLAG: {
                    this.validateFlag(value, reader, i);
                    node.get(Attribute.FLAG.getLocalName()).set(value);
                    continue block14;
                }
                case TYPE: {
                    this.validateType(value, reader, i);
                    node.get(Attribute.TYPE.getLocalName()).set(value);
                    continue block14;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        block15: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case SECURITY_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case MODULE_OPTION: {
                            this.parseModuleOption(reader, node.get("module-options"));
                            continue block15;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseAuthenticationJaspi(XMLExtendedStreamReader reader, ModelNode op) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case SECURITY_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    if (!visited.add(element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    switch (element) {
                        case LOGIN_MODULE_STACK: {
                            this.parseLoginModuleStack(reader, op.get(Element.LOGIN_MODULE_STACK.getLocalName()));
                            continue block7;
                        }
                        case AUTH_MODULE: {
                            this.parseAuthModule(reader, op.get(Element.AUTH_MODULE.getLocalName()));
                            continue block7;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseLoginModuleStack(XMLExtendedStreamReader reader, ModelNode op) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        ModelNode moduleStack = null;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    moduleStack = op.add(Attribute.NAME.getLocalName(), value);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        this.parseAuthentication(reader, moduleStack, false);
    }

    private void parseAuthModule(XMLExtendedStreamReader reader, ModelNode op) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.CODE);
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case CODE: {
                    op.get(Attribute.CODE.getLocalName()).set(value);
                    continue block10;
                }
                case LOGIN_MODULE_STACK_REF: {
                    op.get(Attribute.LOGIN_MODULE_STACK_REF.getLocalName()).set(value);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case SECURITY_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case MODULE_OPTION: {
                            this.parseModuleOption(reader, op.get("module-options"));
                            continue block11;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void validateFlag(String flag, XMLExtendedStreamReader reader, int index) throws XMLStreamException {
        if (!(flag.equals("required") || flag.equals("requisite") || flag.equals("sufficient") || flag.equals("optional"))) {
            throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)index);
        }
    }

    private void validateType(String type, XMLExtendedStreamReader reader, int index) throws XMLStreamException {
        if (!(type.equals("attribute") || type.equals("credential") || type.equals("principal") || type.equals("role"))) {
            throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)index);
        }
    }

    private void parseModuleOption(XMLExtendedStreamReader reader, ModelNode moduleOptions) throws XMLStreamException {
        String name = null;
        String val = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.VALUE);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block4;
                }
                case VALUE: {
                    val = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        moduleOptions.add(name, val);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private String getCode(String code, Element type) {
        String value = null;
        switch (type) {
            case AUTHENTICATION: {
                Set entries = AUTHENTICATION_MAP.entrySet();
                for (Map.Entry mapEntry : entries) {
                    if (!((String)mapEntry.getValue()).equals(code)) continue;
                    value = (String)mapEntry.getKey();
                    break;
                }
                return value;
            }
        }
        return code;
    }
}

