/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelQueryOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.service.SarSubsystemAdd;
import org.jboss.as.service.SarSubsystemProviders;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class SarExtension
implements Extension {
    public static final String NAMESPACE = "urn:jboss:domain:sar:1.0";
    public static final String SUBSYSTEM_NAME = "sar";
    static final SarSubsystemParser parser = new SarSubsystemParser();

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        ModelNodeRegistration registration = subsystem.registerSubsystemModel(SarSubsystemProviders.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationHandler)SarSubsystemAdd.INSTANCE, SarSubsystemProviders.SUBSYSTEM_ADD, false);
        registration.registerOperationHandler("describe", (OperationHandler)SarDescribeHandler.INSTANCE, (DescriptionProvider)SarDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        subsystem.registerXMLElementWriter((XMLElementWriter)parser);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(NAMESPACE, (XMLElementReader)parser);
    }

    private static ModelNode createAddOperation() {
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").add("subsystem", SUBSYSTEM_NAME);
        return subsystem;
    }

    private static class SarDescribeHandler
    implements ModelQueryOperationHandler,
    DescriptionProvider {
        static final SarDescribeHandler INSTANCE = new SarDescribeHandler();

        private SarDescribeHandler() {
        }

        public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) {
            ModelNode node = new ModelNode();
            node.add(SarExtension.createAddOperation());
            resultHandler.handleResultFragment(Util.NO_LOCATION, node);
            resultHandler.handleResultComplete();
            return new BasicOperationResult();
        }

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    }

    static class SarSubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        SarSubsystemParser() {
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(SarExtension.NAMESPACE, false);
            writer.writeEndElement();
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            list.add(SarExtension.createAddOperation());
        }
    }
}

