/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.lang.reflect.Method;
import org.jboss.as.service.SecurityActions;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.Value;

public class StartStopService<T>
implements Service<T> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.service");
    private final Value<T> serviceValue;

    public StartStopService(Value<T> serviceValue) {
        this.serviceValue = serviceValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        T service = this.getValue();
        log.debugf("Starting Service: %s", (Object)context.getController().getName());
        try {
            Method startMethod = service.getClass().getMethod("start", new Class[0]);
            ClassLoader old = SecurityActions.setThreadContextClassLoader(service.getClass().getClassLoader());
            try {
                startMethod.invoke(service, new Object[0]);
            }
            finally {
                SecurityActions.resetThreadContextClassLoader(old);
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            throw new StartException("Failed to execute legacy service start", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext context) {
        T service = this.getValue();
        log.debugf("Stopping Service: %s", (Object)context.getController().getName());
        try {
            Method stopMethod = service.getClass().getMethod("stop", new Class[0]);
            ClassLoader old = SecurityActions.setThreadContextClassLoader(service.getClass().getClassLoader());
            try {
                stopMethod.invoke(service, new Object[0]);
            }
            finally {
                SecurityActions.resetThreadContextClassLoader(old);
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            log.error((Object)"Failed to execute legacy service stop", (Throwable)e);
        }
    }

    public T getValue() throws IllegalStateException {
        return (T)this.serviceValue.getValue();
    }
}

