/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.MBeanServer;
import org.jboss.as.deployment.DeploymentPhases;
import org.jboss.as.deployment.descriptor.JBossServiceAttributeConfig;
import org.jboss.as.deployment.descriptor.JBossServiceConfig;
import org.jboss.as.deployment.descriptor.JBossServiceConstructorConfig;
import org.jboss.as.deployment.descriptor.JBossServiceDependencyConfig;
import org.jboss.as.deployment.descriptor.JBossServiceXmlDescriptor;
import org.jboss.as.deployment.module.ModuleDeploymentProcessor;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;
import org.jboss.as.jmx.MBeanRegistrationService;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.as.service.CreateDestroyService;
import org.jboss.as.service.StartStopService;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.inject.MethodInjector;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.CachedValue;
import org.jboss.msc.value.ConstructedValue;
import org.jboss.msc.value.LookupClassValue;
import org.jboss.msc.value.LookupConstructorValue;
import org.jboss.msc.value.LookupGetMethodValue;
import org.jboss.msc.value.LookupMethodValue;
import org.jboss.msc.value.LookupSetMethodValue;
import org.jboss.msc.value.MethodValue;
import org.jboss.msc.value.Value;
import org.jboss.msc.value.Values;

public class ParsedServiceDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final long PRIORITY = DeploymentPhases.INSTALL_SERVICES.plus(101L);
    public static final Logger log = Logger.getLogger((String)"org.jboss.as.deployment.service");
    private static final ServiceName MBEAN_SERVICE_NAME_BASE = ServiceName.JBOSS.append(new String[]{"mbean", "service"});
    private static final String CREATE_SUFFIX = "create";
    private static final String START_SUFFIX = "start";

    public void processDeployment(DeploymentUnitContext context) throws DeploymentUnitProcessingException {
        JBossServiceXmlDescriptor serviceXmlDescriptor = (JBossServiceXmlDescriptor)context.getAttachment(JBossServiceXmlDescriptor.ATTACHMENT_KEY);
        if (serviceXmlDescriptor == null) {
            return;
        }
        Module module = (Module)context.getAttachment(ModuleDeploymentProcessor.MODULE_ATTACHMENT_KEY);
        if (module == null) {
            throw new DeploymentUnitProcessingException("Failed to get module attachment for deployment: " + context.getName());
        }
        ModuleClassLoader classLoader = module.getClassLoader();
        Value classLoaderValue = Values.immediateValue((Object)classLoader);
        JBossServiceXmlDescriptor.ControllerMode controllerMode = serviceXmlDescriptor.getControllerMode();
        List serviceConfigs = serviceXmlDescriptor.getServiceConfigs();
        BatchBuilder batchBuilder = context.getBatchBuilder();
        for (JBossServiceConfig serviceConfig : serviceConfigs) {
            this.addService(batchBuilder, serviceConfig, (Value<ClassLoader>)classLoaderValue);
        }
    }

    private void addService(BatchBuilder batchBuilder, JBossServiceConfig serviceConfig, Value<ClassLoader> classLoaderValue) {
        JBossServiceAttributeConfig[] attributeConfigs;
        String codeName = serviceConfig.getCode();
        Value classValue = this.cached((Value)new LookupClassValue(codeName, classLoaderValue));
        ArrayList constructorArguments = new ArrayList();
        ArrayList constructorSignature = new ArrayList();
        JBossServiceConstructorConfig constructorConfig = serviceConfig.getConstructorConfig();
        if (constructorConfig != null) {
            JBossServiceConstructorConfig.Argument[] arguments;
            for (JBossServiceConstructorConfig.Argument argument : arguments = constructorConfig.getArguments()) {
                Value attributeTypeValue = this.cached((Value)new LookupClassValue(argument.getType(), classLoaderValue));
                constructorArguments.add(this.cached(new ArgumentValue(attributeTypeValue, argument.getValue())));
                constructorSignature.add(attributeTypeValue);
            }
        }
        Value constructorValue = this.cached((Value)new LookupConstructorValue(classValue, constructorSignature));
        Value constructedValue = this.cached((Value)new ConstructedValue(constructorValue, constructorArguments));
        CreateDestroyService createDestroyService = new CreateDestroyService(constructedValue);
        StartStopService startStopService = new StartStopService(constructedValue);
        String serviceName = serviceConfig.getName();
        ServiceName createDestroyServiceName = this.convert(serviceName).append(new String[]{CREATE_SUFFIX});
        BatchServiceBuilder createDestroyServiceBuilder = batchBuilder.addService(createDestroyServiceName, createDestroyService);
        ServiceName startStopServiceName = this.convert(serviceName).append(new String[]{START_SUFFIX});
        BatchServiceBuilder startStopServiceBuilder = batchBuilder.addService(startStopServiceName, startStopService);
        startStopServiceBuilder.addDependency(createDestroyServiceName);
        JBossServiceDependencyConfig[] dependencyConfigs = serviceConfig.getDependencyConfigs();
        if (dependencyConfigs != null) {
            for (JBossServiceDependencyConfig dependencyConfig : dependencyConfigs) {
                ServiceName dependencyCreateDestroyServiceName = this.convert(dependencyConfig.getDependencyName()).append(new String[]{CREATE_SUFFIX});
                ServiceName dependencyStartStopServiceName = this.convert(dependencyConfig.getDependencyName()).append(new String[]{START_SUFFIX});
                String optionalAttributeName = dependencyConfig.getOptionalAttributeName();
                if (optionalAttributeName != null) {
                    createDestroyServiceBuilder.addDependency(dependencyCreateDestroyServiceName, this.getPropertyInjector((Value<Class<?>>)classValue, optionalAttributeName, createDestroyService, (Value<?>)Values.injectedValue()));
                } else {
                    createDestroyServiceBuilder.addDependency(dependencyCreateDestroyServiceName);
                }
                startStopServiceBuilder.addDependency(dependencyStartStopServiceName);
            }
        }
        if ((attributeConfigs = serviceConfig.getAttributeConfigs()) != null) {
            for (JBossServiceAttributeConfig attributeConfig : attributeConfigs) {
                String attributeName = attributeConfig.getName();
                JBossServiceAttributeConfig.Inject inject = attributeConfig.getInject();
                JBossServiceAttributeConfig.ValueFactory valueFactory = attributeConfig.getValueFactory();
                if (inject != null) {
                    String propertyName = inject.getPropertyName();
                    Value valueToInject = Values.injectedValue();
                    if (propertyName != null) {
                        valueToInject = this.cached((Value)new MethodValue((Value)new LookupGetMethodValue(classValue, propertyName), valueToInject, Values.emptyList()));
                    }
                    createDestroyServiceBuilder.addDependency(this.convert(inject.getBeanName()).append(new String[]{CREATE_SUFFIX}), this.getPropertyInjector(classValue, attributeName, createDestroyService, valueToInject));
                    startStopServiceBuilder.addDependencies(new ServiceName[]{this.convert(inject.getBeanName()).append(new String[]{START_SUFFIX})});
                    continue;
                }
                if (valueFactory != null) {
                    String methodName = valueFactory.getMethodName();
                    JBossServiceAttributeConfig.ValueFactoryParameter[] parameters = valueFactory.getParameters();
                    ArrayList paramTypes = new ArrayList(parameters.length);
                    ArrayList paramValues = new ArrayList(parameters.length);
                    for (JBossServiceAttributeConfig.ValueFactoryParameter parameter : parameters) {
                        Value attributeTypeValue = this.cached((Value)new LookupClassValue(parameter.getType(), classLoaderValue));
                        paramTypes.add(attributeTypeValue);
                        paramValues.add(this.cached(new ArgumentValue(attributeTypeValue, parameter.getValue())));
                    }
                    Value valueToInject = this.cached((Value)new MethodValue((Value)new LookupMethodValue(classValue, methodName, paramTypes), (Value)Values.injectedValue(), paramValues));
                    createDestroyServiceBuilder.addDependency(this.convert(valueFactory.getBeanName()).append(new String[]{CREATE_SUFFIX}), this.getPropertyInjector(classValue, attributeName, createDestroyService, valueToInject));
                    startStopServiceBuilder.addDependencies(new ServiceName[]{this.convert(valueFactory.getBeanName()).append(new String[]{START_SUFFIX})});
                    continue;
                }
                createDestroyServiceBuilder.addInjectionValue(this.getPropertyInjector((Value<Class<?>>)classValue, attributeName, createDestroyService, (Value<?>)Values.injectedValue()), this.cached(new AttributeValue(classValue, attributeName, attributeConfig.getValue())));
            }
        }
        MBeanRegistrationService mbeanRegistrationService = new MBeanRegistrationService(serviceName);
        batchBuilder.addService(MBeanRegistrationService.SERVICE_NAME.append(new String[]{serviceName}), (Service)mbeanRegistrationService).addDependency(MBeanServerService.SERVICE_NAME, MBeanServer.class, mbeanRegistrationService.getMBeanServerInjector()).addDependency(startStopServiceName, Object.class, mbeanRegistrationService.getValueInjector());
    }

    private Injector<Object> getPropertyInjector(Value<Class<?>> classValue, String propertyName, CreateDestroyService<?> startStopService, Value<?> value) {
        return new MethodInjector(this.cached((Value)new LookupSetMethodValue(classValue, propertyName)), startStopService, null, Collections.singletonList(value));
    }

    private ServiceName convert(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        return MBEAN_SERVICE_NAME_BASE.append(new String[]{name});
    }

    private <T> Value<T> cached(Value<T> value) {
        return new CachedValue(value);
    }

    private static class ArgumentValue<T>
    implements Value<T> {
        private final Value<Class<?>> typeValue;
        private final String value;

        private ArgumentValue(Value<Class<?>> typeValue, String value) {
            this.typeValue = typeValue;
            this.value = value;
        }

        public T getValue() throws IllegalStateException {
            Class type = (Class)this.typeValue.getValue();
            PropertyEditor editor = PropertyEditorManager.findEditor(type);
            if (editor == null) {
                log.warn((Object)("Unable to find PropertyEditor for type " + type));
                return null;
            }
            editor.setAsText(this.value);
            return (T)editor.getValue();
        }
    }

    private static class AttributeValue<T>
    implements Value<T> {
        private final Value<Class<?>> targetClassValue;
        private final String name;
        private final String value;

        private AttributeValue(Value<Class<?>> targetClassValue, String name, String value) {
            this.targetClassValue = targetClassValue;
            this.name = name;
            this.value = value;
        }

        public T getValue() throws IllegalStateException {
            Method[] methods;
            Class<?> type = null;
            String expectedMethodName = "set" + Character.toUpperCase(this.name.charAt(0)) + this.name.substring(1);
            Class targetType = (Class)this.targetClassValue.getValue();
            for (Method method : methods = targetType.getMethods()) {
                Class<?>[] types;
                if (!expectedMethodName.equals(method.getName()) || (types = method.getParameterTypes()).length != 1) continue;
                type = types[0];
                break;
            }
            if (type == null) {
                log.warn((Object)("Unable to find type for property " + this.name + " on class " + targetType));
                return null;
            }
            PropertyEditor editor = PropertyEditorManager.findEditor(type);
            if (editor == null) {
                log.warn((Object)("Unable to find PropertyEditor for type " + type));
                return null;
            }
            editor.setAsText(this.value);
            return (T)editor.getValue();
        }
    }
}

