/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.lang.reflect.Method;
import org.jboss.as.service.SecurityActions;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.Value;

public class CreateDestroyService<T>
implements Service<T> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.service");
    private final Value<T> serviceValue;

    public CreateDestroyService(Value<T> serviceValue) {
        this.serviceValue = serviceValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        T service = this.getValue();
        log.debugf("Creating Service: %s", (Object)context.getController().getName());
        try {
            Method createMethod = service.getClass().getMethod("create", new Class[0]);
            ClassLoader old = SecurityActions.setThreadContextClassLoader(service.getClass().getClassLoader());
            try {
                createMethod.invoke(service, new Object[0]);
            }
            finally {
                SecurityActions.resetThreadContextClassLoader(old);
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            throw new StartException("Failed to execute legacy service create", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext context) {
        T service = this.getValue();
        log.debugf("Destroying Service: %s", (Object)context.getController().getName());
        try {
            Method destroyMethod = service.getClass().getMethod("destroy", new Class[0]);
            ClassLoader old = SecurityActions.setThreadContextClassLoader(service.getClass().getClassLoader());
            try {
                destroyMethod.invoke(service, new Object[0]);
            }
            finally {
                SecurityActions.resetThreadContextClassLoader(old);
            }
            destroyMethod.invoke(service, new Object[0]);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            log.error((Object)"Failed to execute legacy service destroy", (Throwable)e);
        }
    }

    public T getValue() throws IllegalStateException {
        return (T)this.serviceValue.getValue();
    }
}

