/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.remoting.AbstractOutboundConnectionService;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.remote.RemoteConnectionProviderFactory;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

public class RemoteOutboundConnectionService
extends AbstractOutboundConnectionService<RemoteOutboundConnectionService> {
    public static final ServiceName REMOTE_OUTBOUND_CONNECTION_BASE_SERVICE_NAME = RemotingServices.SUBSYSTEM_ENDPOINT.append(new String[]{"remote-outbound-connection"});
    private static final String REMOTE_URI_SCHEME = "remote://";
    private final InjectedValue<OutboundSocketBinding> destinationOutboundSocketBindingInjectedValue = new InjectedValue();
    private URI connectionURI;

    public RemoteOutboundConnectionService(String connectionName, OptionMap connectionCreationOptions) {
        super(connectionName, connectionCreationOptions);
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        Endpoint endpoint = (Endpoint)this.endpointInjectedValue.getValue();
        if (!endpoint.isValidUriScheme(REMOTE_URI_SCHEME)) {
            try {
                endpoint.addConnectionProvider(REMOTE_URI_SCHEME, (ConnectionProviderFactory)new RemoteConnectionProviderFactory(), OptionMap.EMPTY);
            }
            catch (IOException ioe) {
                throw new StartException("Could not register a connection provider factory for remote:// uri scheme", (Throwable)ioe);
            }
        }
    }

    @Override
    public IoFuture<Connection> connect() throws IOException {
        URI uri;
        try {
            uri = this.getConnectionURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        Endpoint endpoint = (Endpoint)this.endpointInjectedValue.getValue();
        return endpoint.connect(uri, this.connectionCreationOptions, this.getCallbackHandler());
    }

    Injector<OutboundSocketBinding> getDestinationOutboundSocketBindingInjector() {
        return this.destinationOutboundSocketBindingInjectedValue;
    }

    private synchronized URI getConnectionURI() throws IOException, URISyntaxException {
        if (this.connectionURI != null) {
            return this.connectionURI;
        }
        OutboundSocketBinding destinationOutboundSocket = (OutboundSocketBinding)this.destinationOutboundSocketBindingInjectedValue.getValue();
        InetAddress destinationAddress = destinationOutboundSocket.getDestinationAddress();
        int port = destinationOutboundSocket.getDestinationPort();
        this.connectionURI = new URI(REMOTE_URI_SCHEME + destinationAddress.getHostAddress() + ":" + port);
        return this.connectionURI;
    }

    public RemoteOutboundConnectionService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

