/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.remoting.Element;
import org.jboss.as.remoting.RemotingSubsystemElement;
import org.jboss.as.remoting.SaslElement;
import org.jboss.msc.service.ServiceName;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public final class ConnectorElement
extends AbstractModelElement<ConnectorElement> {
    private static final long serialVersionUID = 4093084317901337638L;
    public static final ServiceName JBOSS_REMOTING_CONNECTOR = RemotingSubsystemElement.JBOSS_REMOTING.append(new String[]{"connector"});
    private final String name;
    private String socketBinding;
    private SaslElement saslElement;
    private String authenticationProvider;
    private Map<String, String> connectorProperties;

    public ConnectorElement(String name, String socketBinding) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
        if (socketBinding == null) {
            throw new IllegalArgumentException("socketBinding is null");
        }
        this.socketBinding = socketBinding;
    }

    protected Class<ConnectorElement> getElementClass() {
        return ConnectorElement.class;
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeAttribute("name", this.name);
        streamWriter.writeAttribute("socket-binding", this.name);
        if (this.saslElement != null) {
            streamWriter.writeStartElement(Element.SASL.getLocalName());
            this.saslElement.writeContent(streamWriter);
        }
        if (this.authenticationProvider != null) {
            streamWriter.writeStartElement(Element.AUTHENTICATION_PROVIDER.getLocalName());
            streamWriter.writeAttribute("name", this.authenticationProvider);
            streamWriter.writeEndElement();
        }
        streamWriter.writeEndElement();
    }

    public String getName() {
        return this.name;
    }

    public String getSocketBinding() {
        return this.socketBinding;
    }

    public String getAuthenticationProvider() {
        return this.authenticationProvider;
    }

    void setAuthenticationProvider(String authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }

    public SaslElement getSaslElement() {
        return this.saslElement;
    }

    void setSaslElement(SaslElement saslElement) {
        this.saslElement = saslElement;
    }

    public Map<String, String> getConnectorProperties() {
        return this.connectorProperties;
    }

    void setConnectorProperties(Map<String, String> connectorProperties) {
        this.connectorProperties = connectorProperties;
    }

    static ServiceName connectorName(String name) {
        return JBOSS_REMOTING_CONNECTOR.append(new String[]{name});
    }
}

