/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.old;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.as.protocol.ProtocolMessages;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.Marshalling;

public class ChunkyByteInput
extends InputStream
implements ByteInput {
    public static final int CHUNK_START = 152;
    public static final int END = 153;
    private ByteInput input;
    private int remaining = 0;
    private boolean finished;

    public ChunkyByteInput(ByteInput byteInput) {
        this.input = byteInput;
    }

    public ChunkyByteInput(InputStream inputStream) {
        this.input = Marshalling.createByteInput((InputStream)inputStream);
    }

    public ChunkyByteInput(InputStream inputStream, int remaining) {
        this.input = Marshalling.createByteInput((InputStream)inputStream);
        this.remaining = remaining;
    }

    @Override
    public int read() throws IOException {
        if (this.remaining == 0) {
            this.startChunk();
        }
        if (this.remaining < 1) {
            return this.remaining;
        }
        --this.remaining;
        return this.input.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret = 0;
        while (len != 0) {
            if (this.remaining == 0) {
                this.startChunk();
            }
            if (this.remaining < 1) {
                return ret;
            }
            int toRead = Math.min(len, this.remaining);
            int read = this.input.read(b, off, toRead);
            this.remaining -= read;
            len -= read;
            off += read;
            ret += read;
            if (read >= toRead) continue;
            return ret;
        }
        return ret;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.remaining == 0) {
            this.startChunk();
        }
        if (this.remaining < 1) {
            return 0L;
        }
        long toSkip = n < (long)this.remaining ? n : (long)this.remaining;
        long ret = this.input.skip(toSkip);
        this.remaining -= (int)ret;
        return ret;
    }

    @Override
    public int available() throws IOException {
        return this.remaining;
    }

    @Override
    public void close() throws IOException {
        while (!this.finished) {
            int current = this.input.read();
            switch (current) {
                case -1: {
                    return;
                }
                case 153: {
                    this.finished = true;
                }
            }
        }
    }

    private void startChunk() throws IOException {
        int current = this.input.read();
        switch (current) {
            case -1: {
                this.remaining = -1;
                break;
            }
            case 152: {
                this.remaining = this.readInt();
                break;
            }
            case 153: {
                this.remaining = -1;
                this.finished = true;
                break;
            }
            default: {
                throw ProtocolMessages.MESSAGES.invalidStartChunk(current);
            }
        }
    }

    private int readInt() throws IOException {
        return this.input.read() << 24 | (this.input.read() & 0xFF) << 16 | (this.input.read() & 0xFF) << 8 | this.input.read() & 0xFF;
    }
}

