/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol;

import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.Executor;
import org.jboss.as.protocol.Connection;
import org.jboss.as.protocol.MessageHandler;
import org.jboss.as.protocol.Pipe;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.logging.Logger;

final class ConnectionImpl
implements Connection {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.protocol.connection");
    private final Socket socket;
    private final Object lock = new Object();
    private OutputStream sender;
    private boolean readDone;
    private boolean writeDone;
    private volatile MessageHandler messageHandler;
    private final Executor readExecutor;
    private volatile Object attachment;

    ConnectionImpl(Socket socket, MessageHandler handler, Executor readExecutor) {
        this.socket = socket;
        this.messageHandler = handler;
        this.readExecutor = readExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream writeMessage() throws IOException {
        BufferedOutputStream os;
        Object object = this.lock;
        synchronized (object) {
            if (this.writeDone) {
                throw new IOException("Writes are already shut down");
            }
            while (this.sender != null) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
            boolean ok = false;
            try {
                this.sender = new MessageOutputStream();
                os = new BufferedOutputStream(this.sender);
                ok = true;
            }
            finally {
                if (!ok) {
                    this.lock.notify();
                }
            }
        }
        return os;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownWrites() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.writeDone) {
                return;
            }
            while (this.sender != null) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
            this.writeDone = true;
            if (this.readDone) {
                this.socket.close();
            } else {
                this.socket.shutdownOutput();
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
            this.sender = null;
            this.readDone = true;
            this.writeDone = true;
            this.socket.close();
            this.lock.notifyAll();
        }
    }

    @Override
    public void setMessageHandler(MessageHandler messageHandler) {
        if (messageHandler == null) {
            throw new IllegalArgumentException("messageHandler is null");
        }
        this.messageHandler = messageHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InetAddress getPeerAddress() {
        Object object = this.lock;
        synchronized (object) {
            Socket socket = this.socket;
            if (socket != null) {
                return socket.getInetAddress();
            }
            return null;
        }
    }

    @Override
    public void attach(Object attachment) {
        this.attachment = attachment;
    }

    @Override
    public Object getAttachment() {
        return this.attachment;
    }

    Runnable getReadTask() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int cmd;
                    Pipe pipe = null;
                    InputStream is = ConnectionImpl.this.socket.getInputStream();
                    OutputStream mos = null;
                    int bufferSize = 8192;
                    byte[] buffer = new byte[8192];
                    block10: while (true) {
                        cmd = is.read();
                        switch (cmd) {
                            case -1: {
                                boolean done;
                                log.trace((Object)"Received end of stream");
                                ConnectionImpl.this.safeHandleShutdown();
                                if (mos != null) {
                                    mos.close();
                                    pipe.await();
                                }
                                Object object = ConnectionImpl.this.lock;
                                synchronized (object) {
                                    ConnectionImpl.this.readDone = true;
                                    done = ConnectionImpl.this.writeDone;
                                }
                                if (done) {
                                    StreamUtils.safeClose(ConnectionImpl.this.socket);
                                    ConnectionImpl.this.safeHandleFinished();
                                }
                                return;
                            }
                            case 152: {
                                if (mos == null) {
                                    pipe = new Pipe(8192);
                                    final InputStream pis = pipe.getIn();
                                    mos = pipe.getOut();
                                    ConnectionImpl.this.readExecutor.execute(new Runnable(){

                                        @Override
                                        public void run() {
                                            ConnectionImpl.this.safeHandleMessage(new MessageInputStream(pis));
                                        }
                                    });
                                }
                                int cnt = StreamUtils.readInt(is);
                                log.tracef("Received data chunk of size %d", (Object)cnt);
                                while (true) {
                                    if (cnt <= 0) continue block10;
                                    int sc = is.read(buffer, 0, Math.min(cnt, 8192));
                                    if (sc == -1) {
                                        throw new EOFException("Unexpected end of stream");
                                    }
                                    mos.write(buffer, 0, sc);
                                    cnt -= sc;
                                }
                            }
                            case 153: {
                                log.trace((Object)"Received end data marker");
                                if (mos == null) continue block10;
                                mos.close();
                                pipe.await();
                                mos = null;
                                pipe = null;
                                continue block10;
                            }
                        }
                        break;
                    }
                    throw new IOException("Invalid command byte read: " + cmd);
                }
                catch (IOException e) {
                    ConnectionImpl.this.safeHandlerFailure(e);
                    return;
                }
            }
        };
    }

    void safeHandleMessage(InputStream pis) {
        try {
            this.messageHandler.handleMessage(this, pis);
        }
        catch (RuntimeException e) {
            log.errorf((Throwable)e, "Failed to read a message", new Object[0]);
        }
        catch (IOException e) {
            log.errorf((Throwable)e, "Failed to read a message", new Object[0]);
        }
        catch (NoClassDefFoundError e) {
            log.errorf((Throwable)e, "Failed to read a message", new Object[0]);
        }
        catch (Error e) {
            log.errorf((Throwable)e, "Failed to read a message", new Object[0]);
            throw e;
        }
        finally {
            StreamUtils.safeClose(pis);
        }
    }

    void safeHandleShutdown() {
        try {
            this.messageHandler.handleShutdown(this);
        }
        catch (IOException e) {
            log.errorf((Throwable)e, "Failed to handle socket shut down condition", new Object[0]);
        }
    }

    void safeHandleFinished() {
        try {
            this.messageHandler.handleFinished(this);
        }
        catch (IOException e) {
            log.errorf((Throwable)e, "Failed to handle socket finished condition", new Object[0]);
        }
    }

    void safeHandlerFailure(IOException e) {
        try {
            this.messageHandler.handleFailure(this, e);
        }
        catch (IOException e1) {
            log.errorf((Throwable)e1, "Failed to handle socket failure condition", new Object[0]);
        }
    }

    final class MessageOutputStream
    extends FilterOutputStream {
        private final byte[] hdr;

        MessageOutputStream() throws IOException {
            super(ConnectionImpl.this.socket.getOutputStream());
            this.hdr = new byte[5];
        }

        @Override
        public void write(int b) throws IOException {
            throw new IllegalStateException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return;
            }
            byte[] hdr = this.hdr;
            hdr[0] = -104;
            hdr[1] = (byte)(len >> 24);
            hdr[2] = (byte)(len >> 16);
            hdr[3] = (byte)(len >> 8);
            hdr[4] = (byte)(len >> 0);
            Object object = ConnectionImpl.this.lock;
            synchronized (object) {
                if (ConnectionImpl.this.sender != this || ConnectionImpl.this.writeDone) {
                    if (ConnectionImpl.this.sender == this) {
                        ConnectionImpl.this.sender = null;
                    }
                    ConnectionImpl.this.lock.notifyAll();
                    throw new IOException("Write channel closed");
                }
                log.tracef("Sending data chunk of size %d", (Object)len);
                this.out.write(hdr);
                this.out.write(b, off, len);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = ConnectionImpl.this.lock;
            synchronized (object) {
                if (ConnectionImpl.this.sender != this) {
                    return;
                }
                ConnectionImpl.this.sender = null;
                ConnectionImpl.this.lock.notify();
                if (ConnectionImpl.this.writeDone) {
                    throw new IOException("Write channel closed");
                }
                if (ConnectionImpl.this.readDone) {
                    ConnectionImpl.this.readExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            ConnectionImpl.this.safeHandleFinished();
                        }
                    });
                }
                log.tracef("Sending end of message", new Object[0]);
                this.out.write(153);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            super.finalize();
            Object object = ConnectionImpl.this.lock;
            synchronized (object) {
                if (ConnectionImpl.this.sender == this) {
                    log.warnf("Leaked a message output stream; cleaning", new Object[0]);
                    this.close();
                }
            }
        }
    }

    final class MessageInputStream
    extends FilterInputStream {
        protected MessageInputStream(InputStream in) {
            super(in);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                while (this.in.read() != -1) {
                }
            }
            finally {
                super.close();
            }
        }
    }
}

