/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.context;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.jboss.as.naming.context.ModularReference;

public class GlobalNamespaceObjectFactory
implements ObjectFactory {
    public static Reference createReference(String contextIdentifier, Context context) {
        ModularReference ref = ModularReference.create(Context.class, (RefAddr)new StringRefAddr("nns", contextIdentifier), GlobalNamespaceObjectFactory.class);
        ref.add(new ContextRefAddr(context));
        return ref;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference reference = (Reference)obj;
        StringRefAddr nameAdr = (StringRefAddr)reference.get("nns");
        if (nameAdr == null) {
            throw new NamingException("Invalid context reference.  Not a 'nns' reference.");
        }
        Object ctx = reference.get("context").getContent();
        if (!(ctx instanceof Context)) {
            throw new NamingException("Failed to get global context");
        }
        return ctx;
    }

    private static class ContextRefAddr
    extends RefAddr {
        private static final long serialVersionUID = 4992673639670119399L;
        private final Context context;

        ContextRefAddr(Context ctx) {
            super("context");
            this.context = ctx;
        }

        @Override
        public Object getContent() {
            return this.context;
        }
    }
}

