/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.service;

import javax.management.MBeanServer;
import javax.naming.Context;
import javax.naming.Reference;
import org.jboss.as.model.AbstractSubsystemAdd;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.naming.NamingContext;
import org.jboss.as.naming.context.NamespaceObjectFactory;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.naming.service.ContextService;
import org.jboss.as.naming.service.JavaContextService;
import org.jboss.as.naming.service.JndiView;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.naming.service.NamingSubsystemElement;
import org.jboss.logging.Logger;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.Values;

public final class NamingSubsystemAdd
extends AbstractSubsystemAdd<NamingSubsystemElement> {
    private static final long serialVersionUID = -3087211831484406967L;
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.naming");

    protected NamingSubsystemAdd() {
        super("urn:jboss:domain:naming:1.0");
    }

    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        log.info((Object)"Activating Naming Subsystem");
        NamingContext.initializeNamingManager();
        BatchBuilder builder = updateContext.getBatchBuilder();
        builder.addService(NamingService.SERVICE_NAME, (Service)new NamingService(true));
        JavaContextService javaContextService = new JavaContextService();
        builder.addService(JavaContextService.SERVICE_NAME, (Service)javaContextService).addDependency(NamingService.SERVICE_NAME);
        ContextService globalContextService = new ContextService("global");
        builder.addService(JavaContextService.SERVICE_NAME.append(new String[]{"global"}), (Service)globalContextService).addDependency(JavaContextService.SERVICE_NAME, Context.class, globalContextService.getParentContextInjector());
        NamingSubsystemAdd.addContextFactory(builder, "app");
        NamingSubsystemAdd.addContextFactory(builder, "module");
        NamingSubsystemAdd.addContextFactory(builder, "comp");
        JndiView jndiView = new JndiView();
        builder.addService(ServiceName.JBOSS.append(new String[]{"naming", "jndi", "view"}), (Service)jndiView).addOptionalDependency(ServiceName.JBOSS.append(new String[]{"mbean", "server"}), MBeanServer.class, jndiView.getMBeanServerInjector());
    }

    protected NamingSubsystemElement createSubsystemElement() {
        return new NamingSubsystemElement();
    }

    private static void addContextFactory(BatchBuilder builder, String contextName) {
        Reference appReference = NamespaceObjectFactory.createReference(contextName);
        BinderService binderService = new BinderService(contextName, Values.immediateValue((Object)appReference));
        builder.addService(JavaContextService.SERVICE_NAME.append(new String[]{contextName}), binderService).addDependency(JavaContextService.SERVICE_NAME, Context.class, binderService.getContextInjector());
    }
}

