/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Server;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.as.modcluster.ModCluster;
import org.jboss.as.modcluster.ModClusterLogger;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.web.WebServer;
import org.jboss.dmr.ModelNode;
import org.jboss.modcluster.config.impl.ModClusterConfig;
import org.jboss.modcluster.container.ContainerEventHandler;
import org.jboss.modcluster.container.catalina.CatalinaEventHandlerAdapter;
import org.jboss.modcluster.load.LoadBalanceFactorProvider;
import org.jboss.modcluster.load.impl.DynamicLoadBalanceFactorProvider;
import org.jboss.modcluster.load.impl.SimpleLoadBalanceFactorProvider;
import org.jboss.modcluster.load.metric.LoadMetric;
import org.jboss.modcluster.load.metric.impl.ActiveSessionsLoadMetric;
import org.jboss.modcluster.load.metric.impl.AverageSystemLoadMetric;
import org.jboss.modcluster.load.metric.impl.BusyConnectorsLoadMetric;
import org.jboss.modcluster.load.metric.impl.HeapMemoryUsageLoadMetric;
import org.jboss.modcluster.load.metric.impl.ReceiveTrafficLoadMetric;
import org.jboss.modcluster.load.metric.impl.RequestCountLoadMetric;
import org.jboss.modcluster.load.metric.impl.SendTrafficLoadMetric;
import org.jboss.modcluster.load.metric.impl.SystemMemoryUsageLoadMetric;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class ModClusterService
implements ModCluster,
Service<ModCluster> {
    static final ServiceName NAME = ServiceName.JBOSS.append(new String[]{"mod-cluster"});
    private final String unmaskedPassword;
    private final ModelNode modelconf;
    private CatalinaEventHandlerAdapter adapter;
    private LoadBalanceFactorProvider load;
    private final InjectedValue<WebServer> webServer = new InjectedValue();
    private final InjectedValue<SocketBindingManager> bindingManager = new InjectedValue();
    private final InjectedValue<SocketBinding> binding = new InjectedValue();
    private org.jboss.modcluster.ModClusterService service;
    private ModClusterConfig config;

    public ModClusterService(String unmaskedPassword, ModelNode modelconf) {
        this.unmaskedPassword = unmaskedPassword;
        this.modelconf = modelconf;
    }

    public synchronized void start(StartContext context) throws StartException {
        SimpleLoadBalanceFactorProvider myload;
        SocketBinding binding;
        ModClusterLogger.ROOT_LOGGER.debugf("Starting Mod_cluster Extension", new Object[0]);
        this.config = new ModClusterConfig();
        boolean defaultavert = false;
        try {
            Enumeration<NetworkInterface> ni = NetworkInterface.getNetworkInterfaces();
            while (ni.hasMoreElements()) {
                NetworkInterface intf = ni.nextElement();
                if (!intf.isUp() || !intf.supportsMulticast()) continue;
                defaultavert = true;
            }
        }
        catch (SocketException e) {
            // empty catch block
        }
        if (!this.modelconf.hasDefined("proxy-list")) {
            this.config.setAdvertise(Boolean.valueOf(defaultavert));
        }
        this.config.setAdvertisePort(23364);
        this.config.setAdvertiseGroupAddress("224.0.1.105");
        this.config.setAdvertiseInterface(((SocketBindingManager)this.bindingManager.getValue()).getDefaultInterfaceAddress().getHostAddress());
        this.config.setAutoEnableContexts(true);
        this.config.setStopContextTimeout(10);
        this.config.setSocketTimeout(20000);
        if (this.modelconf.hasDefined("advertise-socket") && (binding = (SocketBinding)this.binding.getValue()) != null) {
            this.config.setAdvertisePort(binding.getMulticastPort());
            this.config.setAdvertiseGroupAddress(binding.getMulticastSocketAddress().getHostName());
            this.config.setAdvertiseInterface(binding.getSocketAddress().getAddress().getHostAddress());
            if (!defaultavert) {
                ModClusterLogger.ROOT_LOGGER.multicastInterfaceNotAvailable();
            }
            this.config.setAdvertise(Boolean.valueOf(true));
        }
        if (this.modelconf.hasDefined("ssl")) {
            this.config.setSsl(true);
            ModelNode ssl = this.modelconf.get("ssl");
            if (ssl.has("key-alias")) {
                this.config.setSslKeyAlias(ssl.get("key-alias").asString());
            }
            if (ssl.has("password")) {
                this.config.setSslTrustStorePassword(this.unmaskedPassword);
                this.config.setSslKeyStorePassword(this.unmaskedPassword);
            }
            if (ssl.has("certificate-key-file")) {
                this.config.setSslKeyStore(ssl.get("certificate-key-file").asString());
            }
            if (ssl.has("cipher-suite")) {
                this.config.setSslCiphers(ssl.get("cipher-suite").asString());
            }
            if (ssl.has("protocol")) {
                this.config.setSslKeyAlias(ssl.get("protocol").asString());
            }
            if (ssl.has("ca-certificate-file")) {
                this.config.setSslTrustStore(ssl.get("ca-certificate-file").asString());
            }
            if (ssl.has("ca-revocation-url")) {
                this.config.setSslCrlFile(ssl.get("ca-revocation-url").asString());
            }
        }
        if (this.modelconf.hasDefined("advertise")) {
            this.config.setAdvertise(Boolean.valueOf(this.modelconf.get("advertise").asBoolean()));
        }
        if (this.modelconf.hasDefined("proxy-list")) {
            this.config.setProxyList(this.modelconf.get("proxy-list").asString());
        }
        if (this.modelconf.hasDefined("proxy-url")) {
            this.config.setProxyList(this.modelconf.get("proxy-url").asString());
        }
        if (this.modelconf.has("advertise-security-key")) {
            this.config.setProxyList(this.modelconf.get("advertise-security-key").asString());
        }
        if (this.modelconf.hasDefined("excluded-contexts")) {
            this.config.setExcludedContexts(this.modelconf.get("excluded-contexts").asString());
        }
        if (this.modelconf.hasDefined("auto-enable-contexts")) {
            this.config.setAutoEnableContexts(this.modelconf.get("auto-enable-contexts").asBoolean());
        }
        if (this.modelconf.hasDefined("stop-context-timeout")) {
            this.config.setStopContextTimeout(this.modelconf.get("socket-timeout").asInt());
            this.config.setStopContextTimeoutUnit(TimeUnit.SECONDS);
        }
        if (this.modelconf.hasDefined("socket-timeout")) {
            this.config.setSocketTimeout(this.modelconf.get("socket-timeout").asInt() * 1000);
        }
        if (this.modelconf.hasDefined("sticky-session")) {
            this.config.setStickySession(this.modelconf.get("sticky-session").asBoolean());
        }
        if (this.modelconf.hasDefined("sticky-session-remove")) {
            this.config.setStickySessionRemove(this.modelconf.get("sticky-session-remove").asBoolean());
        }
        if (this.modelconf.hasDefined("sticky-session-force")) {
            this.config.setStickySessionForce(this.modelconf.get("sticky-session-force").asBoolean());
        }
        if (this.modelconf.hasDefined("worker-timeout")) {
            this.config.setWorkerTimeout(this.modelconf.get("worker-timeout").asInt());
        }
        if (this.modelconf.hasDefined("max-attemps")) {
            this.config.setMaxAttempts(this.modelconf.get("max-attemps").asInt());
        }
        if (this.modelconf.hasDefined("flush-packets")) {
            this.config.setFlushPackets(this.modelconf.get("flush-packets").asBoolean());
        }
        if (this.modelconf.hasDefined("flush-wait")) {
            this.config.setFlushWait(this.modelconf.get("flush-wait").asInt());
        }
        if (this.modelconf.hasDefined("ping")) {
            this.config.setPing(this.modelconf.get("ping").asInt());
        }
        if (this.modelconf.hasDefined("smax")) {
            this.config.setSmax(this.modelconf.get("smax").asInt());
        }
        if (this.modelconf.hasDefined("ttl")) {
            this.config.setTtl(this.modelconf.get("ttl").asInt());
        }
        if (this.modelconf.hasDefined("node-timeout")) {
            this.config.setNodeTimeout(this.modelconf.get("node-timeout").asInt());
        }
        if (this.modelconf.hasDefined("balancer")) {
            this.config.setBalancer(this.modelconf.get("balancer").asString());
        }
        if (this.modelconf.hasDefined("domain")) {
            this.config.setLoadBalancingGroup(this.modelconf.get("domain").asString());
        }
        if (this.modelconf.hasDefined("simple-load-provider")) {
            ModelNode node = this.modelconf.get("simple-load-provider");
            myload = new SimpleLoadBalanceFactorProvider();
            myload.setLoadBalanceFactor(node.get("factor").asInt(1));
            this.load = myload;
        }
        HashSet<LoadMetric> metrics = new HashSet<LoadMetric>();
        if (this.modelconf.hasDefined("dynamic-load-provider")) {
            ModelNode node = this.modelconf.get("dynamic-load-provider");
            int decayFactor = node.get("decay").asInt(2);
            int history = node.get("history").asInt(9);
            if (node.hasDefined("load-metric")) {
                this.addLoadMetrics(metrics, node.get("load-metric"));
            }
            if (node.hasDefined("custom-load-metric")) {
                this.addLoadMetrics(metrics, node.get("custom-load-metric"));
            }
            if (!metrics.isEmpty()) {
                DynamicLoadBalanceFactorProvider loader = new DynamicLoadBalanceFactorProvider(metrics);
                loader.setDecayFactor(decayFactor);
                loader.setHistory(history);
                this.load = loader;
            }
        }
        if (this.load == null) {
            ModClusterLogger.ROOT_LOGGER.useDefaultLoadBalancer();
            myload = new SimpleLoadBalanceFactorProvider();
            myload.setLoadBalanceFactor(1);
            this.load = myload;
        }
        this.service = new org.jboss.modcluster.ModClusterService(this.config, this.load);
        this.adapter = new CatalinaEventHandlerAdapter((ContainerEventHandler)this.service, (Server)((WebServer)this.webServer.getValue()).getServer());
        this.adapter.start();
    }

    public synchronized void stop(StopContext context) {
        if (this.adapter != null) {
            this.adapter.stop();
            this.adapter = null;
        }
    }

    public synchronized ModCluster getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    MBeanServer getMBeanServer() {
        return Registry.getRegistry(null, null).getMBeanServer();
    }

    private void addLoadMetrics(Set<LoadMetric> metrics, ModelNode nodes) {
        for (ModelNode node : nodes.asList()) {
            double capacity = node.get("capacity").asDouble(1.0);
            int weight = node.get("weight").asInt(1);
            Class loadMetricClass = null;
            if (node.hasDefined("type")) {
                String type = node.get("type").asString();
                if (type.equals("cpu")) {
                    loadMetricClass = AverageSystemLoadMetric.class;
                }
                if (type.equals("mem")) {
                    loadMetricClass = SystemMemoryUsageLoadMetric.class;
                }
                if (type.equals("heap")) {
                    loadMetricClass = HeapMemoryUsageLoadMetric.class;
                }
                if (type.equals("sessions")) {
                    loadMetricClass = ActiveSessionsLoadMetric.class;
                }
                if (type.equals("receive-traffic")) {
                    loadMetricClass = ReceiveTrafficLoadMetric.class;
                }
                if (type.equals("send-traffic")) {
                    loadMetricClass = SendTrafficLoadMetric.class;
                }
                if (type.equals("requests")) {
                    loadMetricClass = RequestCountLoadMetric.class;
                }
                if (type.equals("busyness")) {
                    loadMetricClass = BusyConnectorsLoadMetric.class;
                }
            } else {
                String className = node.get("class").asString();
                try {
                    loadMetricClass = this.getClass().getClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    ModClusterLogger.ROOT_LOGGER.errorAddingMetrics(e);
                }
            }
            if (loadMetricClass == null) continue;
            try {
                LoadMetric metric = (LoadMetric)loadMetricClass.newInstance();
                metric.setCapacity(capacity);
                metric.setWeight(weight);
                metrics.add(metric);
            }
            catch (InstantiationException e) {
                ModClusterLogger.ROOT_LOGGER.errorAddingMetrics(e);
            }
            catch (IllegalAccessException e) {
                ModClusterLogger.ROOT_LOGGER.errorAddingMetrics(e);
            }
        }
    }

    public Injector<WebServer> getWebServer() {
        return this.webServer;
    }

    public Injector<SocketBinding> getBinding() {
        return this.binding;
    }

    public Injector<SocketBindingManager> getBindingManager() {
        return this.bindingManager;
    }

    Registry getRegistry() {
        return Registry.getRegistry(null, null);
    }

    void registerObject(MBeanServer mbeanServer, String name, Object obj, String classname) {
        if (mbeanServer != null) {
            try {
                ObjectName objectName = new ObjectName(name);
                this.getRegistry().registerComponent(obj, objectName, classname);
            }
            catch (Exception e) {
                return;
            }
        }
    }

    @Override
    public Map<InetSocketAddress, String> getProxyInfo() {
        return this.service.getProxyInfo();
    }

    @Override
    public void refresh() {
        this.service.refresh();
    }

    @Override
    public void reset() {
        this.service.reset();
    }

    @Override
    public void enable() {
        this.service.enable();
    }

    @Override
    public void disable() {
        this.service.disable();
    }

    @Override
    public void stop(int waittime) {
        this.service.stop((long)waittime, TimeUnit.SECONDS);
    }

    @Override
    public boolean enableContext(String host, String context) {
        return this.service.enableContext(host, context);
    }

    @Override
    public boolean disableContext(String host, String context) {
        return this.service.disableContext(host, context);
    }

    @Override
    public boolean stopContext(String host, String context, int waittime) {
        return this.service.stopContext(host, context, (long)waittime, TimeUnit.SECONDS);
    }

    @Override
    public void addProxy(String host, int port) {
        this.service.addProxy(host, port);
    }

    @Override
    public void removeProxy(String host, int port) {
        this.service.removeProxy(host, port);
    }

    @Override
    public Map<InetSocketAddress, String> getProxyConfiguration() {
        return this.service.getProxyConfiguration();
    }
}

