/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.util;

import java.util.ArrayList;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.filters.AcceptAllFilter;
import org.jboss.logmanager.filters.AllFilter;
import org.jboss.logmanager.filters.AnyFilter;
import org.jboss.logmanager.filters.DenyAllFilter;
import org.jboss.logmanager.filters.InvertFilter;
import org.jboss.logmanager.filters.LevelChangingFilter;
import org.jboss.logmanager.filters.LevelFilter;
import org.jboss.logmanager.filters.LevelRangeFilter;
import org.jboss.logmanager.filters.RegexFilter;
import org.jboss.logmanager.filters.SubstituteFilter;
import org.jboss.logmanager.handlers.AsyncHandler;

public final class ModelParser {
    private static final Pattern SIZE_PATTERN = Pattern.compile("(\\d+)([kKmMgGbBtT])?");

    private ModelParser() {
    }

    public static Filter parseFilter(OperationContext context, ModelNode node) throws OperationFailedException {
        if (node.hasDefined(CommonAttributes.ACCEPT.getName())) {
            return AcceptAllFilter.getInstance();
        }
        if (node.hasDefined(CommonAttributes.ALL.getName())) {
            ArrayList<Filter> filters = new ArrayList<Filter>();
            for (ModelNode n : node.get(CommonAttributes.ALL.getName()).asList()) {
                filters.add(ModelParser.parseFilter(context, n));
            }
            return new AllFilter(filters);
        }
        if (node.hasDefined(CommonAttributes.ANY.getName())) {
            ArrayList<Filter> filters = new ArrayList<Filter>();
            for (ModelNode n : node.get(CommonAttributes.ANY.getName()).asList()) {
                filters.add(ModelParser.parseFilter(context, n));
            }
            return new AnyFilter(filters);
        }
        if (node.hasDefined(CommonAttributes.CHANGE_LEVEL.getName())) {
            return new LevelChangingFilter(ModelParser.parseLevel(CommonAttributes.CHANGE_LEVEL.resolveModelAttribute(context, node)));
        }
        if (node.hasDefined(CommonAttributes.DENY.getName())) {
            return DenyAllFilter.getInstance();
        }
        if (node.hasDefined(CommonAttributes.LEVEL.getName())) {
            return new LevelFilter(ModelParser.parseLevel(CommonAttributes.LEVEL.resolveModelAttribute(context, node)));
        }
        if (node.hasDefined(CommonAttributes.LEVEL_RANGE.getName())) {
            ModelNode levelRange = CommonAttributes.LEVEL_RANGE.resolveModelAttribute(context, node);
            Level min = ModelParser.parseLevel(CommonAttributes.MIN_LEVEL.resolveModelAttribute(context, levelRange));
            Level max = ModelParser.parseLevel(CommonAttributes.MAX_LEVEL.resolveModelAttribute(context, levelRange));
            boolean minInclusive = CommonAttributes.MIN_INCLUSIVE.resolveModelAttribute(context, levelRange).asBoolean();
            boolean maxInclusive = CommonAttributes.MAX_INCLUSIVE.resolveModelAttribute(context, levelRange).asBoolean();
            return new LevelRangeFilter(min, minInclusive, max, maxInclusive);
        }
        if (node.hasDefined(CommonAttributes.MATCH.getName())) {
            return new RegexFilter(CommonAttributes.MATCH.resolveModelAttribute(context, node).asString());
        }
        if (node.hasDefined(CommonAttributes.NOT.getName())) {
            return new InvertFilter(ModelParser.parseFilter(context, CommonAttributes.NOT.resolveModelAttribute(context, node)));
        }
        if (node.hasDefined(CommonAttributes.REPLACE.getName())) {
            ModelNode replace = CommonAttributes.REPLACE.resolveModelAttribute(context, node);
            String pattern = CommonAttributes.PATTERN.resolveModelAttribute(context, replace).asString();
            String replacement = CommonAttributes.REPLACEMENT.resolveModelAttribute(context, replace).asString();
            boolean replaceAll = CommonAttributes.REPLACE_ALL.resolveModelAttribute(context, replace).asBoolean();
            return new SubstituteFilter(pattern, replacement, replaceAll);
        }
        String name = node.hasDefined(CommonAttributes.FILTER.getName()) ? node.get(CommonAttributes.FILTER.getName()).asString() : node.asString();
        throw new OperationFailedException(new ModelNode().set(LoggingMessages.MESSAGES.invalidFilter(name)));
    }

    public static long parseSize(ModelNode node) throws OperationFailedException {
        Matcher matcher = SIZE_PATTERN.matcher(node.asString());
        if (!matcher.matches()) {
            throw new OperationFailedException(new ModelNode().set(LoggingMessages.MESSAGES.invalidSize(node.asString())));
        }
        long qty = Long.parseLong(matcher.group(1), 10);
        String chr = matcher.group(2);
        if (chr != null) {
            switch (chr.charAt(0)) {
                case 'B': 
                case 'b': {
                    break;
                }
                case 'K': 
                case 'k': {
                    qty <<= 10;
                    break;
                }
                case 'M': 
                case 'm': {
                    qty <<= 20;
                    break;
                }
                case 'G': 
                case 'g': {
                    qty <<= 30;
                    break;
                }
                case 'T': 
                case 't': {
                    qty <<= 40;
                    break;
                }
                default: {
                    throw new OperationFailedException(new ModelNode().set(LoggingMessages.MESSAGES.invalidSize(node.asString())));
                }
            }
        }
        return qty;
    }

    public static Level parseLevel(ModelNode node) throws OperationFailedException {
        try {
            return Level.parse(node.asString());
        }
        catch (IllegalArgumentException e) {
            throw new OperationFailedException(new ModelNode().set(LoggingMessages.MESSAGES.invalidLogLevel(node.asString())));
        }
    }

    public static AsyncHandler.OverflowAction parseOverflowAction(ModelNode node) throws OperationFailedException {
        try {
            return AsyncHandler.OverflowAction.valueOf((String)node.asString());
        }
        catch (IllegalArgumentException e) {
            throw new OperationFailedException(new ModelNode().set(LoggingMessages.MESSAGES.invalidOverflowAction(node.asString())));
        }
    }
}

