/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers.file;

import java.util.List;
import java.util.logging.Handler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.handlers.FlushingHandlerAddProperties;
import org.jboss.as.logging.handlers.file.FileHandlers;
import org.jboss.as.logging.handlers.file.PeriodicRotatingFileHandlerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;

public class PeriodicRotatingFileHandlerAdd
extends FlushingHandlerAddProperties<PeriodicRotatingFileHandlerService> {
    public static final PeriodicRotatingFileHandlerAdd INSTANCE = new PeriodicRotatingFileHandlerAdd();

    private PeriodicRotatingFileHandlerAdd() {
        super(new AttributeDefinition[]{CommonAttributes.FILE, CommonAttributes.APPEND, CommonAttributes.SUFFIX});
    }

    @Override
    protected PeriodicRotatingFileHandlerService createHandlerService(OperationContext context, ModelNode model) throws OperationFailedException {
        return new PeriodicRotatingFileHandlerService();
    }

    @Override
    protected void updateRuntime(OperationContext context, ServiceBuilder<Handler> serviceBuilder, String name, PeriodicRotatingFileHandlerService service, ModelNode model, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode suffix;
        ModelNode append;
        super.updateRuntime(context, serviceBuilder, name, service, model, newControllers);
        ModelNode file = CommonAttributes.FILE.resolveModelAttribute(context, model);
        if (file.isDefined()) {
            newControllers.add(FileHandlers.addFile(context, serviceBuilder, service, file, name));
        }
        if ((append = CommonAttributes.APPEND.resolveModelAttribute(context, model)).isDefined()) {
            service.setAppend(append.asBoolean());
        }
        if ((suffix = CommonAttributes.SUFFIX.resolveModelAttribute(context, model)).isDefined()) {
            service.setSuffix(suffix.asString());
        }
    }
}

