/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers.custom;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.JBossLevelMapping;
import org.apache.log4j.Layout;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;

class Log4jAppenderHandler
extends ExtHandler {
    private volatile Appender appender = null;
    private final boolean applyLayout;
    private static final AtomicReferenceFieldUpdater<Log4jAppenderHandler, Appender> appenderUpdater = AtomicReferenceFieldUpdater.newUpdater(Log4jAppenderHandler.class, Appender.class, "appender");

    public Log4jAppenderHandler(Appender appender) {
        this(appender, false);
    }

    public Log4jAppenderHandler(Appender appender, boolean applyLayout) {
        this.applyLayout = applyLayout;
        if (applyLayout) {
            appender.setLayout(null);
        }
        appenderUpdater.set(this, appender);
    }

    public Appender getAppender() {
        return this.appender;
    }

    public void setAppender(Appender appender) {
        Log4jAppenderHandler.checkAccess((ExtHandler)this);
        if (this.applyLayout && appender != null) {
            Formatter formatter = this.getFormatter();
            appender.setLayout((Layout)(formatter == null ? null : new FormatterLayout(formatter)));
        }
        appenderUpdater.set(this, appender);
    }

    public void setFormatter(Formatter newFormatter) throws SecurityException {
        Appender appender;
        if (this.applyLayout && (appender = this.appender) != null) {
            appender.setLayout((Layout)new FormatterLayout(newFormatter));
        }
        super.setFormatter(newFormatter);
    }

    protected void doPublish(ExtLogRecord record) {
        Appender appender = this.appender;
        if (appender == null) {
            throw new IllegalStateException("Appender is closed");
        }
        LoggingEvent event = new LoggingEvent(record, (Category)DummyCategory.of(record.getLoggerName()));
        appender.doAppend(event);
        super.doPublish(record);
    }

    public void flush() {
    }

    public void close() throws SecurityException {
        Log4jAppenderHandler.checkAccess((ExtHandler)this);
        Appender appender = appenderUpdater.getAndSet(this, null);
        if (appender != null) {
            appender.close();
        }
    }

    static ExtLogRecord getLogRecordFor(LoggingEvent event) {
        ExtLogRecord rec = (ExtLogRecord)event.getProperties().get("org.jboss.logmanager.record");
        if (rec != null) {
            return rec;
        }
        ExtLogRecord newRecord = new ExtLogRecord(JBossLevelMapping.getLevelFor((Priority)event.getLevel()), (String)event.getMessage(), event.getFQNOfLoggerClass());
        newRecord.setLoggerName(event.getLoggerName());
        newRecord.setMillis(event.getTimeStamp());
        newRecord.setThreadName(event.getThreadName());
        newRecord.setThrown(event.getThrowableInformation().getThrowable());
        newRecord.setNdc(event.getNDC());
        if (event.locationInformationExists()) {
            LocationInfo locationInfo = event.getLocationInformation();
            newRecord.setSourceClassName(locationInfo.getClassName());
            newRecord.setSourceFileName(locationInfo.getFileName());
            newRecord.setSourceLineNumber(Integer.parseInt(locationInfo.getLineNumber()));
            newRecord.setSourceMethodName(locationInfo.getMethodName());
        }
        return newRecord;
    }

    public final class FormatterLayout
    extends Layout {
        private final Formatter formatter;

        public FormatterLayout(Formatter formatter) {
            this.formatter = formatter;
        }

        public String format(LoggingEvent event) {
            return this.formatter.format((LogRecord)Log4jAppenderHandler.getLogRecordFor(event));
        }

        public boolean ignoresThrowable() {
            return false;
        }

        public void activateOptions() {
        }
    }

    private static final class DummyCategory
    extends Category {
        static DummyCategory of(String name) {
            return new DummyCategory(name);
        }

        protected DummyCategory(String name) {
            super(name);
        }
    }
}

