/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers.custom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Handler;
import org.apache.log4j.Appender;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.handlers.HandlerService;
import org.jboss.as.logging.handlers.custom.Log4jAppenderHandler;
import org.jboss.as.logging.handlers.custom.PropertiesConfigurator;
import org.jboss.dmr.Property;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public final class CustomHandlerService
extends HandlerService<Handler> {
    private final String className;
    private final String moduleName;
    private final List<Property> properties;

    public CustomHandlerService(String className, String moduleName) {
        this.className = className;
        this.moduleName = moduleName;
        this.properties = new ArrayList<Property>();
    }

    @Override
    protected Handler createHandler() throws StartException {
        Object handler;
        block7: {
            ModuleLoader moduleLoader = ModuleLoader.forClass(CustomHandlerService.class);
            ModuleIdentifier id = ModuleIdentifier.create((String)this.moduleName);
            try {
                Class<?> handlerClass = Class.forName(this.className, false, (ClassLoader)moduleLoader.loadModule(id).getClassLoader());
                if (Handler.class.isAssignableFrom(handlerClass)) {
                    handler = (Handler)handlerClass.newInstance();
                    break block7;
                }
                if (Appender.class.isAssignableFrom(handlerClass)) {
                    handler = new Log4jAppenderHandler((Appender)handlerClass.newInstance(), true);
                    break block7;
                }
                throw LoggingMessages.MESSAGES.invalidType(this.className, Handler.class);
            }
            catch (ClassNotFoundException e) {
                throw LoggingMessages.MESSAGES.classNotFound(e, this.className);
            }
            catch (ModuleLoadException e) {
                throw LoggingMessages.MESSAGES.cannotLoadModule(e, this.moduleName);
            }
            catch (InstantiationException e) {
                throw LoggingMessages.MESSAGES.cannotInstantiateClass(e, this.className);
            }
            catch (IllegalAccessException e) {
                throw LoggingMessages.MESSAGES.cannotAccessClass(e, this.className);
            }
        }
        return handler;
    }

    @Override
    protected void start(StartContext context, Handler handler) throws StartException {
        PropertiesConfigurator.setProperties(handler, this.properties);
    }

    @Override
    protected void stop(StopContext context, Handler handler) {
        this.properties.clear();
    }

    public synchronized void addProperty(Property property) {
        this.properties.add(property);
        Object handler = this.getValue();
        if (handler != null) {
            PropertiesConfigurator.setProperties((Handler)handler, this.properties);
        }
    }

    public synchronized void addProperties(Collection<Property> properties) {
        this.properties.addAll(properties);
        Object handler = this.getValue();
        if (handler != null) {
            PropertiesConfigurator.setProperties((Handler)handler, this.properties);
        }
    }

    public synchronized void setProperties(Collection<Property> properties) {
        this.properties.clear();
        this.addProperties(properties);
    }
}

