/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers.async;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import org.jboss.as.logging.handlers.FlushingHandlerService;
import org.jboss.logmanager.handlers.AsyncHandler;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public final class AsyncHandlerService
extends FlushingHandlerService<AsyncHandler> {
    private final List<InjectedValue<Handler>> subhandlers = new ArrayList<InjectedValue<Handler>>();
    private AsyncHandler.OverflowAction overflowAction;
    private int queueLength;

    @Override
    protected AsyncHandler createHandler() {
        return new AsyncHandler(this.queueLength);
    }

    @Override
    protected void start(StartContext context, AsyncHandler handler) throws StartException {
        handler.setOverflowAction(this.overflowAction);
        handler.setAutoFlush(this.isAutoflush());
        Handler[] handlers = new Handler[this.subhandlers.size()];
        int subhandlersSize = this.subhandlers.size();
        for (int i = 0; i < subhandlersSize; ++i) {
            handlers[i] = (Handler)this.subhandlers.get(i).getValue();
        }
        handler.setHandlers(handlers);
    }

    @Override
    protected void stop(StopContext context, AsyncHandler handler) {
        handler.clearHandlers();
    }

    public synchronized void setOverflowAction(AsyncHandler.OverflowAction overflowAction) {
        this.overflowAction = overflowAction;
        AsyncHandler handler = (AsyncHandler)this.getValue();
        if (handler != null) {
            handler.setOverflowAction(overflowAction);
        }
    }

    public synchronized void setQueueLength(int queueLength) {
        this.queueLength = queueLength;
    }

    public synchronized void addHandlers(List<InjectedValue<Handler>> list) {
        this.subhandlers.addAll(list);
        AsyncHandler handler = (AsyncHandler)this.getValue();
        if (handler != null) {
            for (InjectedValue<Handler> injectedHandler : list) {
                handler.addHandler((Handler)injectedHandler.getValue());
            }
        }
    }

    public synchronized void addHandler(InjectedValue<Handler> injectedHandler) {
        this.subhandlers.add(injectedHandler);
        AsyncHandler handler = (AsyncHandler)this.getValue();
        if (handler != null) {
            handler.addHandler((Handler)injectedHandler.getValue());
        }
    }

    public synchronized void removeHandler(Handler subHandler) {
        InjectedValue<Handler> valueToRemove = null;
        for (InjectedValue<Handler> injectedHandler : this.subhandlers) {
            if (!((Handler)injectedHandler.getValue()).equals(subHandler)) continue;
            valueToRemove = injectedHandler;
        }
        if (valueToRemove != null) {
            this.subhandlers.remove(valueToRemove);
            AsyncHandler handler = (AsyncHandler)this.getValue();
            if (handler != null) {
                handler.removeHandler((Handler)valueToRemove.getValue());
            }
        }
    }
}

