/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Handler;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.handlers.FormatterSpec;
import org.jboss.as.logging.handlers.HandlerService;
import org.jboss.as.logging.util.LogServices;
import org.jboss.as.logging.util.ModelParser;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

public abstract class HandlerAddProperties<T extends HandlerService>
extends AbstractAddStepHandler {
    private final Set<String> attributes;
    private final List<AttributeDefinition> attributeDefinitions;

    protected HandlerAddProperties(List<String> attributes, List<? extends AttributeDefinition> attributeDefinitions) {
        this.attributes = new HashSet<String>(attributes);
        this.attributes.addAll(attributes);
        this.attributeDefinitions = new ArrayList<AttributeDefinition>();
        this.attributeDefinitions.add((AttributeDefinition)CommonAttributes.ENCODING);
        this.attributeDefinitions.add((AttributeDefinition)CommonAttributes.FORMATTER);
        this.attributeDefinitions.add((AttributeDefinition)CommonAttributes.LEVEL);
        this.attributeDefinitions.add((AttributeDefinition)CommonAttributes.FILTER);
        this.attributeDefinitions.addAll(attributeDefinitions);
    }

    protected HandlerAddProperties(List<? extends AttributeDefinition> attributeDefinitions) {
        this(Collections.emptyList(), attributeDefinitions);
    }

    protected final void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attributeDefinition : this.attributeDefinitions) {
            attributeDefinition.validateAndSet(operation, model);
        }
        for (String string : this.attributes) {
            this.copy(string, operation, model);
        }
    }

    protected final void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        ServiceTarget serviceTarget = context.getServiceTarget();
        T service = this.createHandlerService(context, model);
        ServiceBuilder serviceBuilder = serviceTarget.addService(LogServices.handlerName(name), service);
        ModelNode level = CommonAttributes.LEVEL.resolveModelAttribute(context, model);
        ModelNode encoding = CommonAttributes.ENCODING.resolveModelAttribute(context, model);
        ModelNode formatter = CommonAttributes.FORMATTER.resolveModelAttribute(context, model);
        ModelNode filter = CommonAttributes.FILTER.resolveModelAttribute(context, model);
        if (level.isDefined()) {
            ((HandlerService)service).setLevel(ModelParser.parseLevel(level));
        }
        try {
            if (encoding.isDefined()) {
                ((HandlerService)service).setEncoding(encoding.asString());
            }
        }
        catch (Throwable t) {
            throw new OperationFailedException(new ModelNode().set(t.getLocalizedMessage()));
        }
        if (formatter.isDefined()) {
            ((HandlerService)service).setFormatterSpec(FormatterSpec.fromModelNode(context, model));
        }
        if (filter.isDefined()) {
            ((HandlerService)service).setFilter(ModelParser.parseFilter(context, filter));
        }
        this.updateRuntime(context, (ServiceBuilder<Handler>)serviceBuilder, name, service, model, newControllers);
        serviceBuilder.addListener((ServiceListener)verificationHandler);
        serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        newControllers.add(serviceBuilder.install());
    }

    protected abstract T createHandlerService(OperationContext var1, ModelNode var2) throws OperationFailedException;

    protected abstract void updateRuntime(OperationContext var1, ServiceBuilder<Handler> var2, String var3, T var4, ModelNode var5, List<ServiceController<?>> var6) throws OperationFailedException;

    protected void copy(String name, ModelNode from, ModelNode to) {
        if (from.hasDefined(name)) {
            to.get(name).set(from.get(name));
        }
    }

    public final Collection<AttributeDefinition> getAttributes() {
        return Collections.unmodifiableCollection(this.attributeDefinitions);
    }
}

