/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.AbstractFileHandlerWriteAttributeHandler;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.ModelParser;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.handlers.SizeRotatingFileHandler;

public class SizeRotatingHandlerWriteAttributeHandler
extends AbstractFileHandlerWriteAttributeHandler<SizeRotatingFileHandler> {
    static final SizeRotatingHandlerWriteAttributeHandler INSTANCE = new SizeRotatingHandlerWriteAttributeHandler();

    private SizeRotatingHandlerWriteAttributeHandler() {
        super(new AttributeDefinition[]{CommonAttributes.MAX_BACKUP_INDEX, CommonAttributes.ROTATE_SIZE});
    }

    @Override
    protected boolean doApplyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, String handlerName, SizeRotatingFileHandler handler) throws OperationFailedException {
        boolean result = super.doApplyUpdateToRuntime(context, operation, attributeName, resolvedValue, currentValue, handlerName, handler);
        if (CommonAttributes.MAX_BACKUP_INDEX.getName().equals(attributeName)) {
            handler.setMaxBackupIndex(resolvedValue.asInt());
            result = false;
        } else if (CommonAttributes.ROTATE_SIZE.getName().equals(attributeName)) {
            handler.setRotateSize(ModelParser.parseSize(resolvedValue));
            result = false;
        }
        return result;
    }

    @Override
    protected void doRevertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, String handlerName, SizeRotatingFileHandler handler) throws OperationFailedException {
        super.doRevertUpdateToRuntime(context, operation, attributeName, valueToRestore, valueToRevert, handlerName, handler);
        if (CommonAttributes.MAX_BACKUP_INDEX.getName().equals(attributeName)) {
            handler.setMaxBackupIndex(valueToRestore.asInt());
        } else if (CommonAttributes.ROTATE_SIZE.getName().equals(attributeName)) {
            handler.setRotateSize(ModelParser.parseSize(valueToRestore));
        }
    }
}

