/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Handler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.logging.LoggerHandlerService;
import org.jboss.as.logging.LoggingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public final class LogServices {
    public static final ServiceName JBOSS_LOGGING = ServiceName.JBOSS.append(new String[]{"logging"});
    public static final ServiceName LOGGER = JBOSS_LOGGING.append(new String[]{"logger"});
    public static final ServiceName ROOT_LOGGER = JBOSS_LOGGING.append(new String[]{"root-logger", "ROOT"});
    public static final ServiceName LOGGER_HANDLER = JBOSS_LOGGING.append(new String[]{"logger-handler"});
    public static final ServiceName ROOT_LOGGER_HANDLER = JBOSS_LOGGING.append(new String[]{"root-logger-handler"});
    public static final ServiceName HANDLER = JBOSS_LOGGING.append(new String[]{"handler"});
    public static final ServiceName HANDLER_FILE = JBOSS_LOGGING.append(new String[]{"handler-file"});

    private LogServices() {
    }

    public static ServiceName loggerName(String name) {
        return "ROOT".equals(name) ? ROOT_LOGGER : LOGGER.append(new String[]{name});
    }

    public static ServiceName loggerHandlerName(String loggerName, String handlerName) {
        return "ROOT".equals(loggerName) ? ROOT_LOGGER_HANDLER.append(new String[]{"ROOT", handlerName}) : LOGGER_HANDLER.append(new String[]{loggerName, handlerName});
    }

    public static ServiceName handlerName(String name) {
        return HANDLER.append(new String[]{name});
    }

    public static ServiceName handlerFileName(String handlerName) {
        return HANDLER_FILE.append(new String[]{handlerName});
    }

    static Collection<ServiceController<?>> installLoggerHandlers(ServiceTarget serviceTarget, String loggerName, ModelNode handlers, ServiceVerificationHandler verificationHandler) {
        ArrayList controllers = new ArrayList();
        for (ModelNode handler : handlers.asList()) {
            String handlerName = handler.asString();
            LoggerHandlerService service = new LoggerHandlerService(loggerName);
            Injector<Handler> injector = service.getHandlerInjector();
            ServiceName serviceName = LogServices.loggerHandlerName(loggerName, handlerName);
            ServiceName dep1 = LogServices.loggerName(loggerName);
            ServiceName dep2 = LogServices.handlerName(handlerName);
            LoggingLogger.ROOT_LOGGER.debugf("Installing: %s - %s - %s", serviceName, dep1, dep2);
            controllers.add(serviceTarget.addService(serviceName, (Service)service).addDependency(dep1).addDependency(dep2, Handler.class, injector).addListener((ServiceListener)verificationHandler).install());
        }
        return controllers;
    }

    static void uninstallLoggerHandlers(OperationContext context, String loggerName, ModelNode handlers) {
        for (ModelNode handler : handlers.asList()) {
            String handlerName = handler.asString();
            context.removeService(LogServices.loggerHandlerName(loggerName, handlerName));
        }
    }
}

