/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Handler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.FlushingHandlerService;
import org.jboss.as.logging.HandlerAddProperties;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;

abstract class FlushingHandlerAddProperties<T extends FlushingHandlerService>
extends HandlerAddProperties<T> {
    protected FlushingHandlerAddProperties(List<String> attributes, AttributeDefinition ... attributeDefinitions) {
        super(attributes, FlushingHandlerAddProperties.join(attributeDefinitions, new AttributeDefinition[]{CommonAttributes.AUTOFLUSH}));
    }

    protected FlushingHandlerAddProperties(AttributeDefinition ... attributeDefinitions) {
        super(FlushingHandlerAddProperties.join(attributeDefinitions, new AttributeDefinition[]{CommonAttributes.AUTOFLUSH}));
    }

    @Override
    protected void updateRuntime(OperationContext context, ServiceBuilder<Handler> serviceBuilder, String name, T service, ModelNode model) throws OperationFailedException {
        ModelNode autoflush = CommonAttributes.AUTOFLUSH.resolveModelAttribute(context, model);
        if (autoflush.isDefined()) {
            service.setAutoflush(autoflush.asBoolean());
        }
    }

    private static List<AttributeDefinition> join(AttributeDefinition[] supplied, AttributeDefinition ... added) {
        ArrayList<AttributeDefinition> result = new ArrayList<AttributeDefinition>();
        for (AttributeDefinition attr : added) {
            result.add(attr);
        }
        result.addAll(Arrays.asList(supplied));
        return result;
    }
}

