/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.logging.Handler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.HandlerUpdateProperties;
import org.jboss.as.logging.LogHandlerPropertiesConfigurator;
import org.jboss.dmr.ModelNode;

public class CustomHandlerUpdateProperties
extends HandlerUpdateProperties<Handler> {
    static final CustomHandlerUpdateProperties INSTANCE = new CustomHandlerUpdateProperties();

    private CustomHandlerUpdateProperties() {
        super("properties");
    }

    @Override
    protected boolean applyUpdateToRuntime(OperationContext context, String handlerName, ModelNode model, ModelNode originalModel, Handler handler) throws OperationFailedException {
        if (model.hasDefined("properties")) {
            LogHandlerPropertiesConfigurator.setProperties(handler, model.get("properties").asPropertyList());
        }
        return false;
    }

    @Override
    protected void revertUpdateToRuntime(OperationContext context, String handlerName, ModelNode model, ModelNode originalModel, Handler handler) throws OperationFailedException {
        if (originalModel.hasDefined("properties")) {
            LogHandlerPropertiesConfigurator.setProperties(handler, originalModel.get("properties").asPropertyList());
        }
    }
}

