/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.AbstractLogHandlerWriteAttributeHandler;
import org.jboss.as.logging.AsyncHandlerAssignSubhandler;
import org.jboss.as.logging.AsyncHandlerUnassignSubhandler;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.ModelParser;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.handlers.AsyncHandler;

public class AsyncHandlerWriteAttributeHandler
extends AbstractLogHandlerWriteAttributeHandler<AsyncHandler> {
    public static final AsyncHandlerWriteAttributeHandler INSTANCE = new AsyncHandlerWriteAttributeHandler();

    private AsyncHandlerWriteAttributeHandler() {
        super(new AttributeDefinition[]{CommonAttributes.OVERFLOW_ACTION, CommonAttributes.SUBHANDLERS, CommonAttributes.QUEUE_LENGTH});
    }

    @Override
    protected boolean doApplyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, String handlerName, AsyncHandler handler) throws OperationFailedException {
        if (CommonAttributes.OVERFLOW_ACTION.getName().equals(attributeName)) {
            handler.setOverflowAction(ModelParser.parseOverflowAction(resolvedValue));
        } else if (CommonAttributes.SUBHANDLERS.getName().equals(attributeName)) {
            AsyncHandlerUnassignSubhandler.removeHandlers((AttributeDefinition)CommonAttributes.SUBHANDLERS, currentValue, context, handlerName);
            AsyncHandlerAssignSubhandler.addHandlers((AttributeDefinition)CommonAttributes.SUBHANDLERS, resolvedValue, context, handlerName);
        } else if (CommonAttributes.QUEUE_LENGTH.getName().equals(attributeName)) {
            return true;
        }
        return false;
    }

    @Override
    protected void doRevertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, String handlerName, AsyncHandler handler) throws OperationFailedException {
        if (CommonAttributes.OVERFLOW_ACTION.getName().equals(attributeName)) {
            handler.setOverflowAction(ModelParser.parseOverflowAction(valueToRestore));
        } else if (CommonAttributes.SUBHANDLERS.getName().equals(attributeName)) {
            AsyncHandlerUnassignSubhandler.removeHandlers((AttributeDefinition)CommonAttributes.SUBHANDLERS, valueToRevert, context, handlerName);
            AsyncHandlerAssignSubhandler.addHandlers((AttributeDefinition)CommonAttributes.SUBHANDLERS, valueToRestore, context, handlerName);
        }
    }
}

