/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Handler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.AsyncHandlerService;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.HandlerAddProperties;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.ModelParser;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.value.InjectedValue;

class AsyncHandlerAdd
extends HandlerAddProperties<AsyncHandlerService> {
    static final AsyncHandlerAdd INSTANCE = new AsyncHandlerAdd();

    private AsyncHandlerAdd() {
        super(Arrays.asList(new AttributeDefinition[]{CommonAttributes.SUBHANDLERS, CommonAttributes.QUEUE_LENGTH, CommonAttributes.OVERFLOW_ACTION}));
    }

    @Override
    protected void updateRuntime(OperationContext context, ServiceBuilder<Handler> serviceBuilder, String name, AsyncHandlerService service, ModelNode model) throws OperationFailedException {
        ArrayList<InjectedValue<Handler>> list = new ArrayList<InjectedValue<Handler>>();
        ModelNode subhandlers = CommonAttributes.SUBHANDLERS.resolveModelAttribute(context, model);
        if (subhandlers.isDefined()) {
            for (ModelNode handlerName : subhandlers.asList()) {
                InjectedValue injectedValue = new InjectedValue();
                serviceBuilder.addDependency(LogServices.handlerName(handlerName.asString()), Handler.class, (Injector)injectedValue);
                list.add((InjectedValue<Handler>)injectedValue);
            }
        }
        service.addHandlers(list);
        service.setQueueLength(CommonAttributes.QUEUE_LENGTH.resolveModelAttribute(context, model).asInt());
        ModelNode overflowAction = CommonAttributes.OVERFLOW_ACTION.resolveModelAttribute(context, model);
        if (overflowAction.isDefined()) {
            service.setOverflowAction(ModelParser.parseOverflowAction(overflowAction));
        }
    }

    @Override
    protected AsyncHandlerService createHandlerService(OperationContext context, ModelNode model) throws OperationFailedException {
        return new AsyncHandlerService();
    }
}

