/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.AbstractLogHandlerWriteAttributeHandler;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.handlers.FileHandler;

abstract class AbstractFileHandlerWriteAttributeHandler<T extends FileHandler>
extends AbstractLogHandlerWriteAttributeHandler<T> {
    protected AbstractFileHandlerWriteAttributeHandler(AttributeDefinition ... attributes) {
        super(AbstractFileHandlerWriteAttributeHandler.join(attributes, new AttributeDefinition[]{CommonAttributes.APPEND, CommonAttributes.AUTOFLUSH}));
    }

    @Override
    protected boolean doApplyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, String handlerName, T handler) throws OperationFailedException {
        if (CommonAttributes.APPEND.getName().equals(attributeName)) {
            handler.setAppend(resolvedValue.asBoolean());
            return true;
        }
        if (CommonAttributes.AUTOFLUSH.getName().equals(attributeName)) {
            handler.setAutoFlush(resolvedValue.asBoolean());
        }
        return false;
    }

    @Override
    protected void doRevertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, String handlerName, T handler) throws OperationFailedException {
        if (CommonAttributes.APPEND.getName().equals(attributeName)) {
            handler.setAppend(valueToRestore.asBoolean());
        } else if (CommonAttributes.AUTOFLUSH.getName().equals(attributeName)) {
            handler.setAutoFlush(valueToRestore.asBoolean());
        }
    }

    private static List<AttributeDefinition> join(AttributeDefinition[] supplied, AttributeDefinition ... added) {
        ArrayList<AttributeDefinition> result = new ArrayList<AttributeDefinition>();
        for (AttributeDefinition attr : added) {
            result.add(attr);
        }
        result.addAll(Arrays.asList(supplied));
        return result;
    }
}

