/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.Arrays;
import java.util.logging.Handler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.CustomHandlerService;
import org.jboss.as.logging.HandlerAddProperties;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;

class CustomHandlerAdd
extends HandlerAddProperties<CustomHandlerService> {
    static final CustomHandlerAdd INSTANCE = new CustomHandlerAdd();

    private CustomHandlerAdd() {
        super(Arrays.asList("properties"), Arrays.asList(CommonAttributes.MODULE, CommonAttributes.CLASS));
    }

    @Override
    protected CustomHandlerService createHandlerService(OperationContext context, ModelNode model) throws OperationFailedException {
        String className = CommonAttributes.CLASS.resolveModelAttribute(context, model).asString();
        String moduleName = CommonAttributes.MODULE.resolveModelAttribute(context, model).asString();
        return new CustomHandlerService(className, moduleName);
    }

    @Override
    protected void updateRuntime(OperationContext context, ServiceBuilder<Handler> serviceBuilder, String name, CustomHandlerService service, ModelNode model) throws OperationFailedException {
        ModelNode properties = model.get("properties");
        if (properties.isDefined()) {
            service.addProperties(properties.asPropertyList());
        }
    }
}

