/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.logging.Filter;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.logmanager.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public abstract class AbstractLoggerService
implements Service<Logger> {
    private final String name;
    private Logger logger;
    private Filter filter;

    protected AbstractLoggerService(String name) {
        this.name = "ROOT".equals(name) ? "" : name;
    }

    protected final String getName() {
        return this.name;
    }

    public final synchronized void start(StartContext context) throws StartException {
        this.logger = Logger.getLogger((String)this.getName());
        if (this.filter != null) {
            this.logger.setFilter(this.filter);
        }
        this.start(context, this.logger);
    }

    protected abstract void start(StartContext var1, Logger var2) throws StartException;

    public final synchronized void stop(StopContext context) {
        this.stop(context, this.getLogger());
    }

    protected abstract void stop(StopContext var1, Logger var2);

    protected Logger getLogger() {
        return this.logger;
    }

    public synchronized Logger getValue() throws IllegalStateException {
        return AbstractLoggerService.notNull(this.getLogger());
    }

    public synchronized void setFilter(Filter filter) {
        this.filter = filter;
        Logger logger2 = this.logger;
        if (logger2 != null) {
            logger2.setFilter(filter);
        }
    }

    private static <T> T notNull(T value) {
        if (value == null) {
            throw LoggingMessages.MESSAGES.serviceNotStarted();
        }
        return value;
    }
}

