/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelQueryOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.logging.LoggerHandlerType;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class LoggingDescribeHandler
implements ModelQueryOperationHandler,
DescriptionProvider {
    static final LoggingDescribeHandler INSTANCE = new LoggingDescribeHandler();

    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) {
        ModelNode model = context.getSubModel();
        PathAddress rootAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement()});
        ModelNode result = new ModelNode();
        result.add(LoggingExtension.NewLoggingSubsystemAdd.createOperation(rootAddress.toModelNode()));
        if (model.hasDefined("root-logger")) {
            ModelNode add = Util.getEmptyOperation((String)"set-root-logger", (ModelNode)rootAddress.toModelNode());
            add.get("level").set(model.get(new String[]{"root-logger", "level"}));
            add.get("handlers").set(model.get(new String[]{"root-logger", "handlers"}));
            result.add(add);
        }
        if (model.hasDefined("logger")) {
            for (Property prop : model.get("logger").asPropertyList()) {
                ModelNode add = Util.getEmptyOperation((String)"add", (ModelNode)rootAddress.append(new PathElement[]{PathElement.pathElement((String)"logger", (String)prop.getName())}).toModelNode());
                add.get("handlers").set(prop.getValue().get("handlers"));
                add.get("level").set(prop.getValue().get("level"));
                result.add(add);
            }
        }
        if (model.hasDefined("handler")) {
            for (Property prop : model.get("handler").asPropertyList()) {
                String name = prop.getName();
                ModelNode handler = prop.getValue();
                LoggerHandlerType type = Enum.valueOf(LoggerHandlerType.class, handler.get("handler-type").asString());
                switch (type) {
                    case ASYNC_HANDLER: {
                        result.add(this.defineAsynchHandler(name, handler, rootAddress));
                        break;
                    }
                    case CONSOLE_HANDLER: {
                        result.add(this.defineConsoleHandler(name, handler, rootAddress));
                        break;
                    }
                    case FILE_HANDLER: {
                        result.add(this.defineFileHandler(name, handler, rootAddress));
                        break;
                    }
                    case PERIODIC_ROTATING_FILE_HANDLER: {
                        result.add(this.definePeriodicRotatingFileHandler(name, handler, rootAddress));
                        break;
                    }
                    case SIZE_ROTATING_FILE_HANDLER: {
                        result.add(this.defineSizeRotatingFileHandler(name, handler, rootAddress));
                        break;
                    }
                }
            }
        }
        resultHandler.handleResultFragment(Util.NO_LOCATION, result);
        resultHandler.handleResultComplete();
        return new BasicOperationResult();
    }

    private ModelNode defineAsynchHandler(String name, ModelNode handler, PathAddress rootAddress) {
        ModelNode add = Util.getEmptyOperation((String)"add-async-handler", (ModelNode)rootAddress.append(new PathElement[]{PathElement.pathElement((String)"handler", (String)name)}).toModelNode());
        add.get("handler-type").set(handler.get("handler-type"));
        add.get("queue-length").set(handler.get("queue-length"));
        add.get("subhandlers").set(handler.get("subhandlers"));
        add.get("level").set(handler.get("level"));
        add.get("overflow-action").set(handler.get("overflow-action"));
        return add;
    }

    private ModelNode defineConsoleHandler(String name, ModelNode handler, PathAddress rootAddress) {
        ModelNode add = Util.getEmptyOperation((String)"add-console-handler", (ModelNode)rootAddress.append(new PathElement[]{PathElement.pathElement((String)"handler", (String)name)}).toModelNode());
        if (handler.hasDefined("autoflush")) {
            add.get("autoflush").set(handler.get("autoflush"));
        }
        if (handler.hasDefined("encoding")) {
            add.get("encoding").set(handler.get("encoding"));
        }
        if (handler.hasDefined("formatter")) {
            add.get("formatter").set(handler.get("formatter"));
        }
        if (handler.hasDefined("handler-type")) {
            add.get("handler-type").set(handler.get("handler-type"));
        }
        if (handler.hasDefined("level")) {
            add.get("level").set(handler.get("level"));
        }
        if (handler.hasDefined("queue-length")) {
            add.get("queue-length").set(handler.get("queue-length"));
        }
        return add;
    }

    private ModelNode defineFileHandler(String name, ModelNode handler, PathAddress rootAddress) {
        ModelNode add = Util.getEmptyOperation((String)"add-file-handler", (ModelNode)rootAddress.append(new PathElement[]{PathElement.pathElement((String)"handler", (String)name)}).toModelNode());
        if (handler.hasDefined("autoflush")) {
            add.get("autoflush").set(handler.get("autoflush"));
        }
        if (handler.hasDefined("encoding")) {
            add.get("encoding").set(handler.get("encoding"));
        }
        if (handler.hasDefined("formatter")) {
            add.get("formatter").set(handler.get("formatter"));
        }
        if (handler.hasDefined("level")) {
            add.get("level").set(handler.get("level"));
        }
        if (handler.hasDefined("file")) {
            add.get("file").set(handler.get("file"));
        }
        if (handler.hasDefined("handler-type")) {
            add.get("handler-type").set(handler.get("handler-type"));
        }
        if (handler.hasDefined("queue-length")) {
            add.get("queue-length").set(handler.get("queue-length"));
        }
        return add;
    }

    private ModelNode definePeriodicRotatingFileHandler(String name, ModelNode handler, PathAddress rootAddress) {
        ModelNode add = Util.getEmptyOperation((String)"add-periodic-handler", (ModelNode)rootAddress.append(new PathElement[]{PathElement.pathElement((String)"handler", (String)name)}).toModelNode());
        if (handler.hasDefined("autoflush")) {
            add.get("autoflush").set(handler.get("autoflush"));
        }
        if (handler.hasDefined("encoding")) {
            add.get("encoding").set(handler.get("encoding"));
        }
        if (handler.hasDefined("formatter")) {
            add.get("formatter").set(handler.get("formatter"));
        }
        if (handler.hasDefined("handler-type")) {
            add.get("handler-type").set(handler.get("handler-type"));
        }
        if (handler.hasDefined("level")) {
            add.get("level").set(handler.get("level"));
        }
        if (handler.hasDefined("file")) {
            add.get("file").set(handler.get("file"));
        }
        if (handler.hasDefined("queue-length")) {
            add.get("queue-length").set(handler.get("queue-length"));
        }
        if (handler.hasDefined("suffix")) {
            add.get("suffix").set(handler.get("suffix"));
        }
        return add;
    }

    private ModelNode defineSizeRotatingFileHandler(String name, ModelNode handler, PathAddress rootAddress) {
        ModelNode add = Util.getEmptyOperation((String)"add-size-periodic-handler", (ModelNode)rootAddress.append(new PathElement[]{PathElement.pathElement((String)"handler", (String)name)}).toModelNode());
        if (handler.hasDefined("autoflush")) {
            add.get("autoflush").set(handler.get("autoflush"));
        }
        if (handler.hasDefined("encoding")) {
            add.get("encoding").set(handler.get("encoding"));
        }
        if (handler.hasDefined("formatter")) {
            add.get("formatter").set(handler.get("formatter"));
        }
        if (handler.hasDefined("handler-type")) {
            add.get("handler-type").set(handler.get("handler-type"));
        }
        if (handler.hasDefined("level")) {
            add.get("level").set(handler.get("level"));
        }
        if (handler.hasDefined("file")) {
            add.get("file").set(handler.get("file"));
        }
        if (handler.hasDefined("max-backup-index")) {
            add.get("max-backup-index").set(handler.get("max-backup-index"));
        }
        if (handler.hasDefined("rotate-size")) {
            add.get("rotate-size").set(handler.get("rotate-size"));
        }
        return add;
    }

    public ModelNode getModelDescription(Locale locale) {
        return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
    }
}

