/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelRemoveOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.logging.LogServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

class LoggerRemove
implements ModelRemoveOperationHandler {
    static final LoggerRemove INSTANCE = new LoggerRemove();

    LoggerRemove() {
    }

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) {
        ModelNode address = operation.get("address");
        final String name = address.get(address.asInt() - 1).asProperty().getValue().asString();
        final ModelNode subModel = context.getSubModel();
        ModelNode compensatingOperation = new ModelNode();
        compensatingOperation.get("address").set(operation.require("address"));
        compensatingOperation.get("operation").set("add");
        compensatingOperation.get("level").set(subModel.get("level"));
        compensatingOperation.get("handlers").set(subModel.get("handlers"));
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceRegistry registry = context.getServiceRegistry();
                    ServiceController controller = registry.getService(LogServices.loggerName(name));
                    if (controller != null) {
                        controller.setMode(ServiceController.Mode.REMOVE);
                    }
                    if (subModel.has("handlers")) {
                        LogServices.uninstallLoggerHandlers(registry, name, subModel.get("handlers"));
                    }
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }
}

