/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelRemoveOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.logging.LogServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

class LoggerHandlerRemove
implements ModelRemoveOperationHandler {
    static final LoggerHandlerRemove INSTANCE = new LoggerHandlerRemove();

    LoggerHandlerRemove() {
    }

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        final String name = address.getLastElement().getValue();
        ModelNode subModel = context.getSubModel();
        ModelNode compensatingOperation = new ModelNode();
        compensatingOperation.get("address").set(operation.require("address"));
        compensatingOperation.get("operation").set("set-root-logger");
        for (Property property : subModel.asPropertyList()) {
            compensatingOperation.get(property.getName()).set(property.getValue());
        }
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceRegistry registry = context.getServiceRegistry();
                    try {
                        ServiceController controller = registry.getService(LogServices.handlerName(name));
                        if (controller != null) {
                            controller.setMode(ServiceController.Mode.REMOVE);
                        }
                        resultHandler.handleResultComplete();
                    }
                    catch (Throwable t) {
                        throw new OperationFailedException(new ModelNode().set(t.getLocalizedMessage()));
                    }
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }
}

