/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.logging.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class LoggingSubsystemProviders {
    static final String RESOURCE_NAME = LoggingSubsystemProviders.class.getPackage().getName() + ".LocalDescriptions";
    static final DescriptionProvider SUBSYSTEM = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            subsystem.get("description").set(bundle.getString("logging"));
            subsystem.get("head-comment-allowed").set(true);
            subsystem.get("tail-comment-allowed").set(true);
            subsystem.get("namespace").set(Namespace.CURRENT.getUriString());
            subsystem.get("operations");
            subsystem.get(new String[]{"children", "root-logger", "description"}).set(bundle.getString("root.logger"));
            subsystem.get(new String[]{"children", "handler", "description"}).set(bundle.getString("handler"));
            return subsystem;
        }
    };
    static final DescriptionProvider SUBSYSTEM_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle.getString("logging.add"));
            operation.get("request-properties").setEmptyObject();
            operation.get("reply-properties").setEmptyObject();
            return operation;
        }
    };
    static final DescriptionProvider SET_ROOT_LOGGER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("operation-name").set("set-root-logger");
            node.get("description").set(bundle.getString("root.logger.set"));
            node.get(new String[]{"request-properties", "level", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "level", "description"}).set(bundle.getString("logger.level"));
            node.get(new String[]{"request-properties", "level", "required"}).set(true);
            node.get(new String[]{"request-properties", "handler", "type"}).set(ModelType.LIST);
            node.get(new String[]{"request-properties", "handler", "value-type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "handler", "description"}).set(bundle.getString("logger.handlers"));
            node.get(new String[]{"request-properties", "handler", "required"}).set(true);
            node.get("reply-properties").setEmptyObject();
            return node;
        }
    };
    static final DescriptionProvider REMOVE_ROOT_LOGGER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("remove-root-logger");
            operation.get("description").set(bundle.getString("root.logger.remove"));
            operation.get("request-properties").setEmptyObject();
            operation.get("reply-properties").setEmptyObject();
            return operation;
        }
    };
    static final DescriptionProvider LOGGER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle.getString("logger"));
            return node;
        }
    };
    static final DescriptionProvider LOGGER_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("operation-name").set("add");
            node.get("description").set(bundle.getString("logger.add"));
            node.get(new String[]{"request-properties", "level", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "level", "description"}).set(bundle.getString("logger.level"));
            node.get(new String[]{"request-properties", "level", "required"}).set(true);
            node.get(new String[]{"request-properties", "handler", "type"}).set(ModelType.LIST);
            node.get(new String[]{"request-properties", "handler", "value-type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "handler", "description"}).set(bundle.getString("logger.handlers"));
            node.get(new String[]{"request-properties", "handler", "required"}).set(false);
            node.get(new String[]{"request-properties", "encoding", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "encoding", "description"}).set(bundle.getString("logger.level"));
            node.get(new String[]{"request-properties", "encoding", "required"}).set(true);
            return node;
        }
    };
    static final DescriptionProvider LOGGER_REMOVE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("operation-name").set("remove");
            node.get("description").set(bundle.getString("logger.remove"));
            node.get("request-properties").setEmptyObject();
            node.get("reply-properties").setEmptyObject();
            return node;
        }
    };
    static final DescriptionProvider HANDLERS = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle.getString("handler"));
            node.get(new String[]{"attributes", "level", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "level", "description"}).set(bundle.getString("logger.level"));
            node.get(new String[]{"attributes", "handler", "type"}).set(ModelType.LIST);
            node.get(new String[]{"attributes", "handler", "value-type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "handler", "description"}).set(bundle.getString("logger.handlers"));
            node.get(new String[]{"attributes", "encoding", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "encoding", "description"}).set(bundle.getString("logger.level"));
            return node;
        }
    };
    static final DescriptionProvider HANDLER_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle.getString("handler.add"));
            return node;
        }
    };
    static final DescriptionProvider HANDLER_REMOVE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle.getString("handler.remove"));
            return node;
        }
    };
    static final DescriptionProvider CONSOLE_HANDLER_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle.getString("console.handler"));
            return node;
        }
    };
    static final DescriptionProvider FILE_HANDLER_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle.getString("file.handler"));
            return node;
        }
    };
    static final DescriptionProvider PERIODIC_HANDLER_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle.getString("periodic.handler"));
            return node;
        }
    };
    static final DescriptionProvider SIZE_PERIODIC_HANDLER_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle.getString("size.periodic.handler"));
            return node;
        }
    };

    LoggingSubsystemProviders() {
    }

    static final ModelNode getAsyncModelDescription(Locale locale) {
        ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("async.handler"));
        return node;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }

    public static void main(String[] args) {
        System.out.println(SUBSYSTEM.getModelDescription(null));
        System.out.println(SUBSYSTEM_ADD.getModelDescription(null));
        System.out.println(CONSOLE_HANDLER_ADD.getModelDescription(null));
        System.out.println(FILE_HANDLER_ADD.getModelDescription(null));
        System.out.println(HANDLER_ADD.getModelDescription(null));
        System.out.println(HANDLER_REMOVE.getModelDescription(null));
        System.out.println(HANDLERS.getModelDescription(null));
        System.out.println(LOGGER.getModelDescription(null));
        System.out.println(LOGGER_ADD.getModelDescription(null));
        System.out.println(LOGGER_REMOVE.getModelDescription(null));
        System.out.println(PERIODIC_HANDLER_ADD.getModelDescription(null));
        System.out.println(REMOVE_ROOT_LOGGER.getModelDescription(null));
        System.out.println(SET_ROOT_LOGGER.getModelDescription(null));
        System.out.println(SIZE_PERIODIC_HANDLER_ADD.getModelDescription(null));
    }
}

