/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.logging.AsyncHandlerAdd;
import org.jboss.as.logging.ConsoleHandlerAdd;
import org.jboss.as.logging.FileHandlerAdd;
import org.jboss.as.logging.LoggerAdd;
import org.jboss.as.logging.LoggerHandlerAdd;
import org.jboss.as.logging.LoggerHandlerRemove;
import org.jboss.as.logging.LoggerRemove;
import org.jboss.as.logging.LoggingDescribeHandler;
import org.jboss.as.logging.LoggingSubsystemParser;
import org.jboss.as.logging.LoggingSubsystemProviders;
import org.jboss.as.logging.Namespace;
import org.jboss.as.logging.PeriodicRotatingFileHandlerAdd;
import org.jboss.as.logging.RootLoggerAdd;
import org.jboss.as.logging.RootLoggerRemove;
import org.jboss.as.logging.SizeRotatingFileHandlerAdd;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class LoggingExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "logging";
    private static final PathElement loggersPath = PathElement.pathElement((String)"logger");
    private static final PathElement handlersPath = PathElement.pathElement((String)"handler");

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        ModelNodeRegistration registration = subsystem.registerSubsystemModel(LoggingSubsystemProviders.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationHandler)NewLoggingSubsystemAdd.ADD_INSTANCE, LoggingSubsystemProviders.SUBSYSTEM_ADD, false);
        registration.registerOperationHandler("describe", (OperationHandler)LoggingDescribeHandler.INSTANCE, (DescriptionProvider)LoggingDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        registration.registerOperationHandler("set-root-logger", (OperationHandler)RootLoggerAdd.INSTANCE, LoggingSubsystemProviders.SET_ROOT_LOGGER, false);
        registration.registerOperationHandler("remove-root-logger", (OperationHandler)RootLoggerRemove.INSTANCE, LoggingSubsystemProviders.REMOVE_ROOT_LOGGER, false);
        subsystem.registerXMLElementWriter((XMLElementWriter)LoggingSubsystemParser.getInstance());
        ModelNodeRegistration loggers = registration.registerSubModel(loggersPath, LoggingSubsystemProviders.LOGGER);
        loggers.registerOperationHandler("add", (OperationHandler)LoggerAdd.INSTANCE, LoggingSubsystemProviders.LOGGER_ADD, false);
        loggers.registerOperationHandler("remove", (OperationHandler)LoggerRemove.INSTANCE, LoggingSubsystemProviders.LOGGER_REMOVE, false);
        ModelNodeRegistration handlers = registration.registerSubModel(handlersPath, LoggingSubsystemProviders.HANDLERS);
        handlers.registerOperationHandler("add", (OperationHandler)LoggerHandlerAdd.INSTANCE, LoggingSubsystemProviders.HANDLER_ADD, false);
        handlers.registerOperationHandler("remove", (OperationHandler)LoggerHandlerRemove.INSTANCE, LoggingSubsystemProviders.HANDLER_REMOVE, false);
        handlers.registerOperationHandler("add-async-handler", (OperationHandler)AsyncHandlerAdd.INSTANCE, (DescriptionProvider)AsyncHandlerAdd.INSTANCE, false);
        handlers.registerOperationHandler("add-console-handler", (OperationHandler)ConsoleHandlerAdd.INSTANCE, LoggingSubsystemProviders.CONSOLE_HANDLER_ADD, false);
        handlers.registerOperationHandler("add-file-handler", (OperationHandler)FileHandlerAdd.INSTANCE, LoggingSubsystemProviders.FILE_HANDLER_ADD, false);
        handlers.registerOperationHandler("add-periodic-handler", (OperationHandler)PeriodicRotatingFileHandlerAdd.INSTANCE, LoggingSubsystemProviders.PERIODIC_HANDLER_ADD, false);
        handlers.registerOperationHandler("add-size-periodic-handler", (OperationHandler)SizeRotatingFileHandlerAdd.INSTANCE, LoggingSubsystemProviders.SIZE_PERIODIC_HANDLER_ADD, false);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUriString(), (XMLElementReader)LoggingSubsystemParser.getInstance());
    }

    static class NewLoggingSubsystemAdd
    implements ModelAddOperationHandler {
        static final NewLoggingSubsystemAdd ADD_INSTANCE = new NewLoggingSubsystemAdd();

        NewLoggingSubsystemAdd() {
        }

        public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) {
            ModelNode compensatingOperation = new ModelNode();
            compensatingOperation.get("operation").set("remove");
            compensatingOperation.get("address").set(operation.get("address"));
            ModelNode subModel = context.getSubModel();
            subModel.get("logger").setEmptyObject();
            subModel.get("handler").setEmptyObject();
            resultHandler.handleResultComplete();
            return new BasicOperationResult(compensatingOperation);
        }

        static ModelNode createOperation(ModelNode address) {
            ModelNode subsystem = new ModelNode();
            subsystem.get("operation").set("add");
            subsystem.get("address").set(address);
            return subsystem;
        }
    }
}

